/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish;

import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.JellyTorchBlock;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishBoostGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishSwimIntoDirectionGoal;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ImmortalJellyfishEntity
extends AbstractJellyfishEntity {
    private final AbstractJellyfishEntity.BucketProcessor<ImmortalJellyfishEntity> bucketProcessor;
    private AbstractJellyfishEntity.RotationController rotationController = new AbstractJellyfishEntity.RotationController(this);
    private int healCooldown;
    private float prevHealth;

    public ImmortalJellyfishEntity(EntityType<? extends AbstractJellyfishEntity> type, World world) {
        super(type, world);
        this.bucketProcessor = new AbstractJellyfishEntity.BucketProcessor<ImmortalJellyfishEntity>("immortal_jellyfish", this);
        this.prevHealth = this.func_110143_aJ();
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233818_a_, 7.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (Goal)new JellyfishSwimIntoDirectionGoal(this, SWIM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, (Goal)new JellyfishBoostGoal(this, BOOST_ANIMATION));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.healCooldown > 0) {
            --this.healCooldown;
        } else if (this.field_70173_aa % 5 == 0) {
            this.func_70691_i(0.5f);
        }
        if (this.prevHealth > this.func_110143_aJ()) {
            this.healCooldown = this.func_70681_au().nextInt(40) + 20;
        }
        this.prevHealth = this.func_110143_aJ();
    }

    public void onEndimationStart(Endimation endimation) {
        if (endimation == SWIM_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.35f, 1.0f);
        } else if (endimation == BOOST_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.2f, 1.0f);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.healCooldown = compound.func_74762_e("HealCooldown");
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("HealCooldown", this.healCooldown);
    }

    @Override
    public AbstractJellyfishEntity.RotationController getRotationController() {
        return this.rotationController;
    }

    @Override
    public String getBucketName() {
        return "immortal";
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        return this.func_70681_au().nextFloat() < 0.75f ? JellyTorchBlock.JellyTorchType.WHITE : JellyTorchBlock.JellyTorchType.RED;
    }

    @Override
    public float getCooldownChance() {
        return 0.8f;
    }

    @Override
    public int getIdSuffix() {
        return 7;
    }

    @Override
    public ITextComponent getYieldingTorchMessage() {
        JellyTorchBlock.JellyTorchType white = JellyTorchBlock.JellyTorchType.WHITE;
        JellyTorchBlock.JellyTorchType red = JellyTorchBlock.JellyTorchType.RED;
        return new TranslationTextComponent("tooltip.upgrade_aquatic.yielding_jelly_torch").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.upgrade_aquatic." + white.toString().toLowerCase() + "_jelly_torch").func_240699_a_(white.color)).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.upgrade_aquatic.yielding_jelly_torch.or").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.upgrade_aquatic." + red.toString().toLowerCase() + "_jelly_torch").func_240699_a_(red.color));
    }

    public int func_70641_bl() {
        return 3;
    }

    @Override
    public AbstractJellyfishEntity.BucketProcessor<?> getBucketProcessor() {
        return this.bucketProcessor;
    }
}

