/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.other;

import com.minecraftabnormals.upgrade_aquatic.common.entities.LionfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.PikeEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ThrasherEntity;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAEntities;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgrade_aquatic")
public class UASpawns {
    public static void registerSpawns() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.NAUTILUS.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, UASpawns::ravineMobCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.LIONFISH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, LionfishEntity::coralCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.PIKE.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, PikeEntity::pickerelCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.GLOW_SQUID.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, UASpawns::ravineMobCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.THRASHER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, ThrasherEntity::thrasherCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.GREAT_THRASHER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, ThrasherEntity::thrasherCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.BOX_JELLYFISH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, AbstractJellyfishEntity::defaultSpawnCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.CASSIOPEA_JELLYFISH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, AbstractJellyfishEntity::defaultSpawnCondition);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)UAEntities.IMMORTAL_JELLYFISH.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING, AbstractJellyfishEntity::defaultSpawnCondition);
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            return;
        }
        ResourceLocation biome = event.getName();
        MobSpawnInfoBuilder spawns = event.getSpawns();
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome);
        if (event.getCategory() == Biome.Category.OCEAN) {
            spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners((EntityType)UAEntities.GLOW_SQUID.get(), 67, 1, 1));
            if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                spawns.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners((EntityType)UAEntities.THRASHER.get(), 90, 1, 2));
            } else {
                spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)UAEntities.NAUTILUS.get(), 51, 1, 4));
            }
            if (BiomeDictionary.hasType((RegistryKey)key, (BiomeDictionary.Type)BiomeDictionary.Type.HOT)) {
                spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)UAEntities.LIONFISH.get(), 15, 1, 1));
            }
        }
        if (event.getCategory() == Biome.Category.RIVER) {
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)UAEntities.PIKE.get(), 11, 1, 2));
        }
        if (event.getCategory() == Biome.Category.SWAMP) {
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners((EntityType)UAEntities.PIKE.get(), 5, 1, 2));
            spawns.func_242575_a(EntityClassification.WATER_CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200749_ao, 5, 1, 2));
            spawns.func_242575_a(EntityClassification.WATER_AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_203778_ae, 5, 1, 5));
        }
    }

    public static boolean ravineMobCondition(EntityType<? extends CreatureEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (((World)world).func_234923_W_() != World.field_234918_g_) {
            return false;
        }
        return pos.func_177956_o() <= 30;
    }

    public static boolean isLukewarmOcean(ResourceLocation biome) {
        return biome.equals((Object)Biomes.field_203615_U.func_240901_a_()) || biome.equals((Object)Biomes.field_203618_X.func_240901_a_());
    }

    public static boolean isWarmOcean(ResourceLocation biome) {
        return biome.equals((Object)Biomes.field_203614_T.func_240901_a_()) || biome.equals((Object)Biomes.field_203617_W.func_240901_a_());
    }
}

