/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SRConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    private static String makeTranslation(String name) {
        return "savageandravage.config." + name;
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> creepiesGrowLargerOnExplosion;
        public final ForgeConfigSpec.ConfigValue<Boolean> creepieSprout;

        public Client(ForgeConfigSpec.Builder builder) {
            this.creepiesGrowLargerOnExplosion = builder.comment("If true, creepies grow significantly larger when they explode").translation(SRConfig.makeTranslation("creepiesGrowLargerOnExplosion")).define("Creepies grow larger on explosion", false);
            this.creepieSprout = builder.comment("If true, creepies have a sprout on their head").translation(SRConfig.makeTranslation("creepieSprout")).define("Creepie sprout", true);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> creeperExplosionsDestroyBlocks;
        public final ForgeConfigSpec.ConfigValue<Boolean> creeperExplosionsSpawnCreepies;
        public final ForgeConfigSpec.ConfigValue<Boolean> creepersDropSporesAfterExplosionDeath;

        public Common(ForgeConfigSpec.Builder builder) {
            this.creeperExplosionsDestroyBlocks = builder.translation(SRConfig.makeTranslation("creeperExplosionsDestroyBlocks")).define("Creeper explosions destroy blocks", false);
            this.creeperExplosionsSpawnCreepies = builder.translation(SRConfig.makeTranslation("creeperExplosionsSpawnCreepies")).define("Creeper explosions spawn creepies", true);
            this.creepersDropSporesAfterExplosionDeath = builder.translation(SRConfig.makeTranslation("creepersDropSporesAfterExplosionDeath")).define("Creepers drop Creeper Spores after they die from an explosion", true);
        }
    }
}

