/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core.other;

import com.minecraftabnormals.abnormals_core.core.api.IAgeableEntity;
import com.minecraftabnormals.savageandravage.common.effect.GrowingEffect;
import com.minecraftabnormals.savageandravage.common.effect.ShrinkingEffect;
import com.minecraftabnormals.savageandravage.common.entity.BurningBannerEntity;
import com.minecraftabnormals.savageandravage.common.entity.CreepieEntity;
import com.minecraftabnormals.savageandravage.common.entity.ExecutionerEntity;
import com.minecraftabnormals.savageandravage.common.entity.GrieferEntity;
import com.minecraftabnormals.savageandravage.common.entity.IOwnableMob;
import com.minecraftabnormals.savageandravage.common.entity.IceologerEntity;
import com.minecraftabnormals.savageandravage.common.entity.SkeletonVillagerEntity;
import com.minecraftabnormals.savageandravage.common.entity.SporeCloudEntity;
import com.minecraftabnormals.savageandravage.common.entity.block.SporeBombEntity;
import com.minecraftabnormals.savageandravage.common.entity.goals.AvoidGrieferOwnedCreepiesGoal;
import com.minecraftabnormals.savageandravage.common.entity.goals.ImprovedCrossbowGoal;
import com.minecraftabnormals.savageandravage.common.item.PottableItem;
import com.minecraftabnormals.savageandravage.core.SRConfig;
import com.minecraftabnormals.savageandravage.core.other.SRTags;
import com.minecraftabnormals.savageandravage.core.registry.SRAttributes;
import com.minecraftabnormals.savageandravage.core.registry.SRBlocks;
import com.minecraftabnormals.savageandravage.core.registry.SREffects;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import com.minecraftabnormals.savageandravage.core.registry.SRItems;
import com.minecraftabnormals.savageandravage.core.registry.SRSounds;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.FireChargeItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="savageandravage")
public class SREvents {
    public static final Method setSize = ObfuscationReflectionHelper.findMethod(SlimeEntity.class, (String)"func_70799_a", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PillagerEntity) {
            PillagerEntity pillager = (PillagerEntity)event.getEntity();
            ImprovedCrossbowGoal<PillagerEntity> aiCrossBow = new ImprovedCrossbowGoal<PillagerEntity>(pillager, 1.0, 8.0f, 5.0);
            pillager.field_70714_bg.field_220892_d.stream().map(it -> it.field_220774_a).filter(it -> it instanceof RangedCrossbowAttackGoal).findFirst().ifPresent(crossbowGoal -> {
                pillager.field_70714_bg.func_85156_a(crossbowGoal);
                pillager.field_70714_bg.func_75776_a(3, (Goal)aiCrossBow);
            });
            if (event.getWorld().field_73012_v.nextInt(100) == 0 && !event.getWorld().func_201670_d()) {
                pillager.func_184201_a(EquipmentSlotType.OFFHAND, SREvents.createRocket());
                pillager.func_184598_c(Hand.OFF_HAND);
                pillager.func_184642_a(EquipmentSlotType.OFFHAND, 2.0f);
            }
        }
        if (event.getEntity() instanceof IronGolemEntity && !((Boolean)SRConfig.COMMON.creeperExplosionsDestroyBlocks.get()).booleanValue()) {
            IronGolemEntity golem = (IronGolemEntity)event.getEntity();
            golem.field_70715_bh.field_220892_d.stream().map(it -> it.field_220774_a).filter(it -> it instanceof NearestAttackableTargetGoal).findFirst().ifPresent(noAngryAtCreeper -> {
                golem.field_70715_bh.func_85156_a(noAngryAtCreeper);
                golem.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)golem, MobEntity.class, 5, false, false, p_213619_0_ -> p_213619_0_ instanceof IMob));
            });
        }
        if (event.getEntity().func_200600_R() == EntityType.field_200797_k && !((Boolean)SRConfig.COMMON.creeperExplosionsDestroyBlocks.get()).booleanValue()) {
            CreeperEntity creeper = (CreeperEntity)event.getEntity();
            creeper.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)creeper, IronGolemEntity.class, true));
        }
        if (event.getEntity() instanceof CatEntity) {
            CatEntity cat = (CatEntity)event.getEntity();
            cat.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)cat, CreepieEntity.class, false));
        }
        if (event.getEntity() instanceof OcelotEntity) {
            OcelotEntity ocelot = (OcelotEntity)event.getEntity();
            ocelot.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)ocelot, CreepieEntity.class, false));
        }
        if (event.getEntity() instanceof AbstractVillagerEntity) {
            AbstractVillagerEntity villager = (AbstractVillagerEntity)event.getEntity();
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, SkeletonVillagerEntity.class, 8.0f, 0.6, 0.6));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, GrieferEntity.class, 8.0f, 0.8, 0.8));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, IceologerEntity.class, 8.0f, 0.8, 0.8));
            villager.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)villager, ExecutionerEntity.class, 8.0f, 0.8, 0.8));
            villager.field_70714_bg.func_75776_a(1, new AvoidGrieferOwnedCreepiesGoal<CreepieEntity>((CreatureEntity)villager, CreepieEntity.class, 8.0f, 0.8, 0.8));
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity().func_200600_R() == EntityType.field_200797_k) {
            CreeperEntity creeper = (CreeperEntity)event.getEntity();
            if (event.getSource().func_94541_c() && ((Boolean)SRConfig.COMMON.creepersDropSporesAfterExplosionDeath.get()).booleanValue()) {
                creeper.func_199701_a_(new ItemStack((IItemProvider)SRItems.CREEPER_SPORES.get(), 1 + creeper.field_70170_p.field_73012_v.nextInt(3)));
            }
        } else if (event.getEntity() instanceof PillagerEntity) {
            PillagerEntity pillager = (PillagerEntity)event.getEntity();
            if (pillager.field_70170_p.func_201670_d() && ((ServerWorld)pillager.func_130014_f_()).func_217475_c_(pillager.func_233580_cy_()) != null) {
                pillager.func_199701_a_(new ItemStack((IItemProvider)Items.field_151166_bC, pillager.field_70170_p.field_73012_v.nextInt(2)));
                if (pillager.field_70170_p.field_73012_v.nextDouble() < 0.05) {
                    pillager.func_199701_a_(new ItemStack((IItemProvider)Items.field_151166_bC, 4 + pillager.field_70170_p.field_73012_v.nextInt(1)));
                }
                if (pillager.field_70170_p.field_73012_v.nextDouble() < 0.12) {
                    pillager.func_199701_a_(new ItemStack((IItemProvider)Items.field_151166_bC, 2 + pillager.field_70170_p.field_73012_v.nextInt(1)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof GolemEntity && !(event.getEntityLiving() instanceof ShulkerEntity) && event.getTarget() instanceof IOwnableMob && ((IOwnableMob)event.getTarget()).getOwner() instanceof PlayerEntity && ((MobEntity)event.getTarget()).func_70638_az() != event.getEntityLiving()) {
            ((GolemEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        World world = event.getWorld();
        Explosion explosion = event.getExplosion();
        if (explosion.func_94613_c() != null && explosion.func_94613_c().func_200600_R() == EntityType.field_200797_k) {
            if (!((Boolean)SRConfig.COMMON.creeperExplosionsDestroyBlocks.get()).booleanValue()) {
                event.getAffectedBlocks().clear();
            }
            if (((Boolean)SRConfig.COMMON.creeperExplosionsSpawnCreepies.get()).booleanValue()) {
                CreeperEntity creeper = (CreeperEntity)explosion.func_94613_c();
                SporeCloudEntity spores = (SporeCloudEntity)((EntityType)SREntities.SPORE_CLOUD.get()).func_200721_a(world);
                if (spores == null) {
                    return;
                }
                spores.setSpawnCloudInstantly(true);
                spores.creepiesAttackPlayersOnly(true);
                spores.setCloudSize(creeper.func_225509_J__() ? (int)(creeper.func_110143_aJ() / 4.0f) : (int)(creeper.func_110143_aJ() / 5.0f));
                spores.func_82149_j((Entity)creeper);
                creeper.field_70170_p.func_217376_c((Entity)spores);
            }
        }
        if (explosion.getExploder() != null && explosion.getExploder().func_200600_R() == SREntities.SPORE_BOMB.get()) {
            for (BlockPos pos : event.getAffectedBlocks()) {
                if (world.func_180495_p(pos).func_177230_c() != SRBlocks.SPORE_BOMB.get()) continue;
                world.func_217377_a(pos, false);
                SporeBombEntity sporebomb = new SporeBombEntity(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, explosion.func_94613_c());
                sporebomb.func_184534_a((short)(world.func_201674_k().nextInt(sporebomb.func_184536_l() / 4) + sporebomb.func_184536_l() / 8));
                world.func_217376_c((Entity)sporebomb);
            }
        }
        ArrayList<Entity> safeItems = new ArrayList<Entity>();
        for (Entity entity : event.getAffectedEntities()) {
            ItemStack itemstack;
            if (!(entity instanceof ItemEntity) || !(itemstack = ((ItemEntity)entity).func_92059_d()).func_77973_b().func_206844_a(SRTags.BLAST_PROOF_ITEMS)) continue;
            safeItems.add(entity);
        }
        event.getAffectedEntities().removeAll(safeItems);
    }

    @SubscribeEvent
    public static void handleBlastProof(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (event.getSource().func_94541_c()) {
            double decrease = 0.0;
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ItemStack stack = entity.func_184582_a(slot);
                Collection modifiers = stack.func_111283_C(slot).get((Object)SRAttributes.EXPLOSIVE_DAMAGE_REDUCTION.get());
                if (modifiers.isEmpty()) continue;
                decrease += modifiers.stream().mapToDouble(AttributeModifier::func_111164_d).sum();
                stack.func_222118_a(22 - EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185297_d, (ItemStack)stack) * 8, entity, onBroken -> onBroken.func_213361_c(slot));
            }
            if (decrease == 0.0) {
                return;
            }
            event.setAmount(event.getAmount() - (float)((double)event.getAmount() * decrease));
        }
    }

    @SubscribeEvent
    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Entity target = event.getTarget();
        if ((target.func_200600_R() == EntityType.field_200797_k || target.func_200600_R() == SREntities.CREEPIE.get()) && stack.func_77973_b() == Items.field_196167_cx) {
            World world = event.getWorld();
            CreepieEntity creepie = (CreepieEntity)((EntityType)SREntities.CREEPIE.get()).func_200721_a(world);
            if (creepie != null) {
                creepie.func_82149_j(target);
                if (stack.func_82837_s()) {
                    creepie.func_200203_b(stack.func_200301_q());
                }
                if (!event.getPlayer().func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                creepie.attackPlayersOnly = true;
                world.func_217376_c((Entity)creepie);
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.func_201670_d()));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        World world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos()).func_177230_c() instanceof AbstractBannerBlock) {
            List burningBanners = world.func_217357_a(BurningBannerEntity.class, new AxisAlignedBB(pos));
            for (BurningBannerEntity burningBanner : burningBanners) {
                if (burningBanner.getBannerPosition() == null || !burningBanner.getBannerPosition().equals((Object)pos)) continue;
                burningBanner.extinguishFire();
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isFlintAndSteel;
        ItemStack stack = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        if (stack.func_77973_b() instanceof PottableItem && world.func_180495_p(pos).func_177230_c() == Blocks.field_150457_bL) {
            BlockState pottedState = ((PottableItem)stack.func_77973_b()).getPottedState(player.func_174811_aO().func_176734_d());
            if (pottedState == null) {
                return;
            }
            world.func_175656_a(pos, pottedState);
            player.func_195066_a(Stats.field_188088_V);
            if (!event.getPlayer().func_184812_l_()) {
                stack.func_190918_g(1);
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        } else if (SREvents.isValidBurningBannerPos(world, pos) && ((isFlintAndSteel = stack.func_77973_b() instanceof FlintAndSteelItem) || stack.func_77973_b() instanceof FireChargeItem)) {
            SoundEvent sound = isFlintAndSteel ? SoundEvents.field_187649_bu : SoundEvents.field_187616_bj;
            float pitch = isFlintAndSteel ? new Random().nextFloat() * 0.4f + 0.8f : (new Random().nextFloat() - new Random().nextFloat()) * 0.2f + 1.0f;
            world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 1.0f, pitch);
            if (isFlintAndSteel) {
                stack.func_222118_a(1, (LivingEntity)player, p_219998_1_ -> p_219998_1_.func_213334_d(event.getHand()));
            } else if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            world.func_217376_c((Entity)new BurningBannerEntity(world, pos, player));
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_223314_ad() > 0 && entity.func_70660_b((Effect)SREffects.FROSTBITE.get()) != null) {
            entity.func_195063_d((Effect)SREffects.FROSTBITE.get());
        }
    }

    public static boolean isValidBurningBannerPos(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() instanceof AbstractBannerBlock) {
            List banners = world.func_217357_a(BurningBannerEntity.class, new AxisAlignedBB(pos));
            boolean noBurningBanners = true;
            for (BurningBannerEntity banner : banners) {
                if (banner.getBannerPosition() == null || !banner.getBannerPosition().equals((Object)pos)) continue;
                noBurningBanners = false;
            }
            return noBurningBanners;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPotionExpire(PotionEvent.PotionExpiryEvent event) {
        if (event.getPotionEffect() != null) {
            LivingEntity affected = event.getEntityLiving();
            boolean shouldSetChild = event.getPotionEffect().func_188419_a() instanceof ShrinkingEffect;
            if (event.getPotionEffect().func_188419_a() instanceof GrowingEffect || shouldSetChild) {
                boolean canChange = false;
                if (affected instanceof IAgeableEntity && ((IAgeableEntity)affected).canAge(!shouldSetChild)) {
                    ((IAgeableEntity)affected).attemptAging(!shouldSetChild);
                    canChange = true;
                } else if (affected instanceof SlimeEntity) {
                    SlimeEntity slime = (SlimeEntity)affected;
                    int size = slime.func_70809_q();
                    if (shouldSetChild ? size > 1 : size < 3) {
                        canChange = true;
                        try {
                            Object[] objectArray = new Object[2];
                            objectArray[0] = size + (shouldSetChild ? (size < 4 ? -1 : -2) : (size < 2 ? 1 : 2));
                            objectArray[1] = false;
                            setSize.invoke((Object)slime, objectArray);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("Invoking setSize failed. Something has gone horribly wrong with Savage & Ravage!");
                        }
                    }
                } else if (shouldSetChild != affected.func_70631_g_()) {
                    canChange = true;
                    if (affected instanceof AgeableEntity && !(affected instanceof ParrotEntity)) {
                        ((AgeableEntity)affected).func_70873_a(shouldSetChild ? -24000 : 0);
                    } else if (shouldSetChild && affected instanceof CreeperEntity) {
                        SREvents.convertCreeper((CreeperEntity)affected);
                    } else if (affected instanceof ZombieEntity || affected instanceof PiglinEntity || affected instanceof ZoglinEntity) {
                        ((MobEntity)affected).func_82227_f(shouldSetChild);
                    } else {
                        canChange = false;
                    }
                }
                if (!canChange) {
                    if (!shouldSetChild) {
                        affected.func_195064_c(new EffectInstance(Effects.field_76444_x, 2400, 0));
                    }
                    if (affected.func_70662_br()) {
                        shouldSetChild = !shouldSetChild;
                    }
                    EffectInstance effectInstance = new EffectInstance(shouldSetChild ? Effects.field_76433_i : Effects.field_76432_h, 1, 1);
                    effectInstance.func_188419_a().func_180793_a(null, null, affected, effectInstance.func_76458_c(), 1.0);
                }
                if (!affected.field_70170_p.func_201670_d()) {
                    ((ServerWorld)affected.field_70170_p).func_195598_a((IParticleData)(canChange ? (shouldSetChild ? ParticleTypes.field_197604_O : ParticleTypes.field_197632_y) : ParticleTypes.field_197594_E), affected.func_226282_d_(0.3), affected.func_226279_cv_() - 0.1, affected.func_226287_g_(0.3), canChange ? 40 : 20, 0.3, 0.6, 0.3, canChange ? 0.2 : 0.01);
                    affected.func_184185_a(canChange ? (SoundEvent)SRSounds.ENTITY_GENERIC_GROWTH_SUCCESS.get() : (SoundEvent)SRSounds.ENTITY_GENERIC_GROWTH_FAILURE.get(), 1.0f, 1.0f);
                }
            }
        }
    }

    public static void convertCreeper(CreeperEntity creeper) {
        CreepieEntity creepie = (CreepieEntity)((EntityType)SREntities.CREEPIE.get()).func_200721_a(creeper.field_70170_p);
        if (creepie == null) {
            return;
        }
        creepie.func_82149_j(creeper.getEntity());
        creeper.func_70106_y();
        creepie.func_94061_f(creeper.func_175446_cd());
        if (creeper.func_145818_k_()) {
            creepie.func_200203_b(creeper.func_200201_e());
            creepie.func_174805_g(creeper.func_174833_aM());
        }
        if (creeper.func_104002_bU()) {
            creepie.func_110163_bv();
        }
        if (creeper.func_110167_bD() && creeper.func_110166_bE() != null) {
            creepie.func_110162_b(creeper.func_110166_bE(), true);
            creeper.func_110160_i(true, false);
        }
        if (creeper.func_184187_bx() != null) {
            creepie.func_184220_m(creeper.func_184187_bx());
        }
        creepie.func_184224_h(creeper.func_190530_aW());
        creeper.func_70606_j(creeper.func_110138_aP());
        creeper.field_70170_p.func_217376_c((Entity)creepie);
    }

    public static ItemStack createRocket() {
        ItemStack rocket = new ItemStack((IItemProvider)Items.field_196152_dE);
        ItemStack star = new ItemStack((IItemProvider)Items.field_196153_dF);
        CompoundNBT compoundnbt = star.func_190925_c("Explosion");
        compoundnbt.func_74768_a("Type", FireworkRocketItem.Shape.BURST.func_196071_a());
        CompoundNBT compoundnbt1 = rocket.func_190925_c("Fireworks");
        ListNBT listnbt = new ListNBT();
        CompoundNBT compoundnbt2 = star.func_179543_a("Explosion");
        if (compoundnbt2 != null) {
            listnbt.add((Object)compoundnbt2);
        }
        if (!listnbt.isEmpty()) {
            compoundnbt1.func_218657_a("Explosions", (INBT)listnbt);
        }
        return rocket;
    }
}

