/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core.registry;

import com.minecraftabnormals.savageandravage.common.effect.FrostbiteEffect;
import com.minecraftabnormals.savageandravage.common.effect.GrowingEffect;
import com.minecraftabnormals.savageandravage.common.effect.ShrinkingEffect;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.Potions;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SREffects {
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"savageandravage");
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTION_TYPES, (String)"savageandravage");
    public static final RegistryObject<Effect> GROWING = EFFECTS.register("growing", GrowingEffect::new);
    public static final RegistryObject<Effect> SHRINKING = EFFECTS.register("shrinking", ShrinkingEffect::new);
    public static final RegistryObject<Effect> FROSTBITE = EFFECTS.register("frostbite", FrostbiteEffect::new);
    public static final RegistryObject<Potion> GROWTH_NORMAL = POTIONS.register("growth", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)GROWING.get(), 600)}));
    public static final RegistryObject<Potion> GROWTH_LONG = POTIONS.register("growth_long", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)GROWING.get(), 1800)}));
    public static final RegistryObject<Potion> YOUTH_NORMAL = POTIONS.register("youth", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)SHRINKING.get(), 600)}));
    public static final RegistryObject<Potion> YOUTH_LONG = POTIONS.register("youth_long", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)SHRINKING.get(), 1800)}));
    private static final Method ADD_MIX_METHOD = ObfuscationReflectionHelper.findMethod(PotionBrewing.class, (String)"func_193357_a", (Class[])new Class[]{Potion.class, Item.class, Potion.class});

    public static void registerBrewingRecipes() {
        SREffects.addMix(Potions.field_185233_e, Items.field_151153_ao, (Potion)GROWTH_NORMAL.get());
        SREffects.addMix((Potion)GROWTH_NORMAL.get(), Items.field_151137_ax, (Potion)GROWTH_LONG.get());
        SREffects.addMix((Potion)GROWTH_NORMAL.get(), Items.field_151071_bq, (Potion)YOUTH_NORMAL.get());
        SREffects.addMix((Potion)GROWTH_LONG.get(), Items.field_151071_bq, (Potion)YOUTH_LONG.get());
        SREffects.addMix((Potion)YOUTH_NORMAL.get(), Items.field_151137_ax, (Potion)YOUTH_LONG.get());
    }

    private static void addMix(Potion input, Item reactant, Potion result) {
        try {
            ADD_MIX_METHOD.invoke(null, input, reactant, result);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to add mix for " + result.getRegistryName() + " from " + reactant.getRegistryName(), e);
        }
    }
}

