/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.advancement.modification;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.AdvancementModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.ConfiguredAdvancementModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.TargetedAdvancementModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers.AdvancementModifiers;
import com.minecraftabnormals.abnormals_core.core.AbnormalsCore;
import com.minecraftabnormals.abnormals_core.core.events.AdvancementBuildingEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="abnormals_core")
public final class AdvancementModificationManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<ResourceLocation, List<ConfiguredAdvancementModifier<?, ?>>> MODIFIERS = Maps.newHashMap();
    private static AdvancementModificationManager INSTANCE;
    private final LootPredicateManager lootPredicateManager;

    private AdvancementModificationManager(LootPredicateManager lootPredicateManager) {
        super(GSON, "modifiers/advancements");
        this.lootPredicateManager = lootPredicateManager;
    }

    public static AdvancementModificationManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onReloadListener(AddReloadListenerEvent event) throws NoSuchFieldException, IllegalAccessException {
        List initTaskQueue;
        INSTANCE = new AdvancementModificationManager(event.getDataPackRegistries().func_240964_b_());
        Field field = AddReloadListenerEvent.class.getDeclaredField("dataPackRegistries");
        field.setAccessible(true);
        SimpleReloadableResourceManager reloadableResourceManager = (SimpleReloadableResourceManager)((DataPackRegistries)field.get(event)).func_240970_h_();
        List reloadListeners = (List)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)reloadableResourceManager, (String)"field_199015_d");
        if (reloadListeners != null) {
            reloadListeners.add(4, INSTANCE);
        }
        if ((initTaskQueue = (List)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)reloadableResourceManager, (String)"field_219539_d")) != null) {
            initTaskQueue.add(4, INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onBuildingAdvancement(AdvancementBuildingEvent event) {
        List<ConfiguredAdvancementModifier<?, ?>> modifiers = MODIFIERS.get(event.getLocation());
        if (modifiers != null) {
            Advancement.Builder builder = event.getBuilder();
            modifiers.forEach(modifier -> modifier.modify(builder));
        }
    }

    private static TargetedAdvancementModifier deserializeModifiers(JsonElement jsonElement, ConditionArrayParser conditionArrayParser) throws JsonParseException {
        JsonObject object = jsonElement.getAsJsonObject();
        ResourceLocation advancement = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"advancement"));
        ArrayList advancementModifiers = Lists.newArrayList();
        JsonArray modifiers = JSONUtils.func_151214_t((JsonObject)object, (String)"modifiers");
        modifiers.forEach(element -> {
            JsonObject entry = element.getAsJsonObject();
            String type = JSONUtils.func_151200_h((JsonObject)entry, (String)"type");
            AdvancementModifier<?> modifier = AdvancementModifiers.getModifier(type);
            if (modifier == null) {
                throw new JsonParseException("Unknown Advancement Modifier type: " + type);
            }
            JsonElement config = entry.get("config");
            if (config == null) {
                throw new JsonParseException("Missing 'config' element!");
            }
            advancementModifiers.add(modifier.deserialize(config, conditionArrayParser));
        });
        return new TargetedAdvancementModifier(advancement, advancementModifiers);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, IResourceManager resourceManager, IProfiler profiler) {
        MODIFIERS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.func_110623_a().startsWith("_")) continue;
            try {
                TargetedAdvancementModifier targetedAdvancementModifier = AdvancementModificationManager.deserializeModifiers(entry.getValue(), new ConditionArrayParser(resourcelocation, this.lootPredicateManager));
                MODIFIERS.computeIfAbsent(targetedAdvancementModifier.getTarget(), target -> new ArrayList()).addAll(targetedAdvancementModifier.getConfiguredModifiers());
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                AbnormalsCore.LOGGER.error("Parsing error loading Advancement Modifier: {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        AbnormalsCore.LOGGER.info("Advancement Modification Manager has loaded {} sets of modifiers", (Object)MODIFIERS.size());
    }
}

