/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.world.gen;

import com.minecraftabnormals.abnormals_core.core.util.BiomeUtil;
import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.area.LazyArea;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer0;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public final class ACLayerUtil {
    public static <R extends IExtendedNoiseRandom<LazyArea>> Layer createEndBiomeLayer(Registry<Biome> lookupRegistry, LongFunction<R> contextFactory) {
        IAreaFactory biomesFactory = new EndBiomesLayer(lookupRegistry).func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        biomesFactory = LayerUtil.func_202829_a((long)100L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomesFactory, (int)2, contextFactory);
        for (int i = 0; i < 3; ++i) {
            biomesFactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L + (long)i), biomesFactory);
        }
        biomesFactory = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(100L), biomesFactory);
        return new Layer(VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), biomesFactory));
    }

    static class EndBiomesLayer
    implements IAreaTransformer0 {
        private final Registry<Biome> lookupRegistry;

        EndBiomesLayer(Registry<Biome> lookupRegistry) {
            this.lookupRegistry = lookupRegistry;
        }

        public int func_215735_a(INoiseRandom random, int x, int z) {
            return this.lookupRegistry.func_148757_b(this.lookupRegistry.func_230516_a_(BiomeUtil.getEndBiome(random)));
        }
    }

    public static enum VoroniZoomLayer implements IAreaTransformer1
    {
        INSTANCE;


        public int func_215728_a(IExtendedNoiseRandom<?> extendedNoiseRandom, IArea area, int p_215728_3_, int p_215728_4_) {
            int i = p_215728_3_ - 2;
            int j = p_215728_4_ - 2;
            int k = i >> 2;
            int l = j >> 2;
            int i1 = k << 2;
            int j1 = l << 2;
            extendedNoiseRandom.func_202698_a((long)i1, (long)j1);
            double d0 = ((double)extendedNoiseRandom.func_202696_a(1024) / 1024.0 - 0.5) * 3.6;
            double d1 = ((double)extendedNoiseRandom.func_202696_a(1024) / 1024.0 - 0.5) * 3.6;
            extendedNoiseRandom.func_202698_a((long)(i1 + 4), (long)j1);
            double d2 = ((double)extendedNoiseRandom.func_202696_a(1024) / 1024.0 - 0.5) * 3.6 + 4.0;
            double d3 = ((double)extendedNoiseRandom.func_202696_a(1024) / 1024.0 - 0.5) * 3.6;
            extendedNoiseRandom.func_202698_a((long)i1, (long)(j1 + 4));
            double d4 = ((double)extendedNoiseRandom.func_202696_a(1024) / 1024.0 - 0.5) * 3.6;
            double d5 = ((double)extendedNoiseRandom.func_202696_a(1024) / 1024.0 - 0.5) * 3.6 + 4.0;
            extendedNoiseRandom.func_202698_a((long)(i1 + 4), (long)(j1 + 4));
            double d6 = ((double)extendedNoiseRandom.func_202696_a(1024) / 1024.0 - 0.5) * 3.6 + 4.0;
            double d7 = ((double)extendedNoiseRandom.func_202696_a(1024) / 1024.0 - 0.5) * 3.6 + 4.0;
            int k1 = i & 3;
            int l1 = j & 3;
            double d8 = ((double)l1 - d1) * ((double)l1 - d1) + ((double)k1 - d0) * ((double)k1 - d0);
            double d9 = ((double)l1 - d3) * ((double)l1 - d3) + ((double)k1 - d2) * ((double)k1 - d2);
            double d10 = ((double)l1 - d5) * ((double)l1 - d5) + ((double)k1 - d4) * ((double)k1 - d4);
            double d11 = ((double)l1 - d7) * ((double)l1 - d7) + ((double)k1 - d6) * ((double)k1 - d6);
            if (d8 < d9 && d8 < d10 && d8 < d11) {
                return area.func_202678_a(this.func_215721_a(i1), this.func_215722_b(j1));
            }
            if (d9 < d8 && d9 < d10 && d9 < d11) {
                return area.func_202678_a(this.func_215721_a(i1 + 4), this.func_215722_b(j1)) & 0xFF;
            }
            return d10 < d8 && d10 < d9 && d10 < d11 ? area.func_202678_a(this.func_215721_a(i1), this.func_215722_b(j1 + 4)) : area.func_202678_a(this.func_215721_a(i1 + 4), this.func_215722_b(j1 + 4)) & 0xFF;
        }

        public int func_215721_a(int x) {
            return x >> 2;
        }

        public int func_215722_b(int z) {
            return z >> 2;
        }
    }
}

