/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.api.banner;

import com.minecraftabnormals.abnormals_core.core.api.banner.BannerManager;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BannerRecipe
extends SpecialRecipe {
    public static final SpecialRecipeSerializer<BannerRecipe> SERIALIZER = new SpecialRecipeSerializer(BannerRecipe::new);

    public BannerRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, @Nonnull World world) {
        boolean foundBanner = false;
        boolean foundItem = false;
        boolean foundDye = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (stack.func_190926_b()) continue;
            if (BannerManager.PATTERNS.containsKey(item.delegate) && !foundItem) {
                foundItem = true;
                continue;
            }
            if (ItemTags.field_202901_n.func_230235_a_((Object)item) && !foundBanner && BannerTileEntity.func_175113_c((ItemStack)stack) < 6) {
                foundBanner = true;
                continue;
            }
            if (item instanceof DyeItem && !foundDye) {
                foundDye = true;
                continue;
            }
            return false;
        }
        return foundBanner && foundItem && foundDye;
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack banner = ItemStack.field_190927_a;
        ItemStack dye = ItemStack.field_190927_a;
        BannerPattern pattern = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            Item item = stack.func_77973_b();
            if (BannerManager.PATTERNS.containsKey(item.delegate)) {
                pattern = BannerManager.PATTERNS.get(item.delegate);
                continue;
            }
            if (ItemTags.field_202901_n.func_230235_a_((Object)item)) {
                banner = stack;
                continue;
            }
            if (!(item instanceof DyeItem)) continue;
            dye = stack;
        }
        return BannerRecipe.applyPattern(banner, pattern, dye);
    }

    private static ItemStack applyPattern(ItemStack banner, BannerPattern pattern, ItemStack dye) {
        ItemStack itemstack = ItemStack.field_190927_a;
        if (!banner.func_190926_b() && !dye.func_190926_b()) {
            ListNBT listnbt;
            itemstack = banner.func_77946_l();
            itemstack.func_190920_e(1);
            DyeColor dyecolor = ((DyeItem)dye.func_77973_b()).func_195962_g();
            CompoundNBT compoundnbt = itemstack.func_190925_c("BlockEntityTag");
            if (compoundnbt.func_150297_b("Patterns", 9)) {
                listnbt = compoundnbt.func_150295_c("Patterns", 10);
            } else {
                listnbt = new ListNBT();
                compoundnbt.func_218657_a("Patterns", (INBT)listnbt);
            }
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_74778_a("Pattern", pattern.func_190993_b());
            compoundnbt1.func_74768_a("Color", dyecolor.func_196059_a());
            listnbt.add((Object)compoundnbt1);
        }
        return itemstack;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }
}

