/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;

public final class BiomeUtil {
    private static final Map<RegistryKey<Biome>, WeightedNoiseList<RegistryKey<Biome>>> HILL_BIOME_MAP = new HashMap<RegistryKey<Biome>, WeightedNoiseList<RegistryKey<Biome>>>();
    private static final WeightedNoiseList<RegistryKey<Biome>> END_BIOMES = new WeightedNoiseList();

    @SafeVarargs
    public static synchronized void addHillBiome(RegistryKey<Biome> biome, Pair<RegistryKey<Biome>, Integer> ... hills) {
        WeightedNoiseList list = HILL_BIOME_MAP.computeIfAbsent(biome, key -> new WeightedNoiseList());
        for (Pair<RegistryKey<Biome>, Integer> hill : hills) {
            list.add(hill.getFirst(), (Integer)hill.getSecond());
        }
    }

    public static synchronized void addEndBiome(RegistryKey<Biome> key, int weight) {
        END_BIOMES.add(key, weight);
    }

    @Nullable
    public static RegistryKey<Biome> getHillBiome(RegistryKey<Biome> biome, INoiseRandom random) {
        WeightedNoiseList<RegistryKey<Biome>> list = HILL_BIOME_MAP.get(biome);
        return list != null ? list.get(random) : null;
    }

    public static RegistryKey<Biome> getEndBiome(INoiseRandom random) {
        return END_BIOMES.get(random);
    }

    static {
        BiomeUtil.addEndBiome((RegistryKey<Biome>)Biomes.field_201937_Q, 15);
    }

    public static final class WeightedNoiseList<T> {
        private final List<Pair<T, Integer>> entries = Lists.newArrayList();
        private int totalWeight;

        public void add(@Nonnull T value, int weight) {
            this.totalWeight += weight;
            this.entries.add(Pair.of(value, (Object)weight));
        }

        @Nonnull
        public T get(INoiseRandom random) {
            Object value;
            Pair<T, Integer> entry;
            Iterator<Pair<T, Integer>> iterator = this.entries.iterator();
            int randomTotal = random.func_202696_a(this.totalWeight);
            do {
                entry = iterator.next();
                value = entry.getFirst();
            } while ((randomTotal -= ((Integer)entry.getSecond()).intValue()) >= 0);
            return (T)value;
        }

        @Nonnull
        public List<Pair<T, Integer>> getEntries() {
            return this.entries;
        }
    }
}

