/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.client.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ocelot.sonar.client.framebuffer.AdvancedFboAttachment;
import io.github.ocelot.sonar.client.framebuffer.AdvancedFboAttachmentColorRenderBuffer;
import io.github.ocelot.sonar.client.framebuffer.AdvancedFboAttachmentColorTexture2D;
import io.github.ocelot.sonar.client.framebuffer.AdvancedFboAttachmentDepthRenderBuffer;
import io.github.ocelot.sonar.client.framebuffer.AdvancedFboAttachmentDepthTexture2D;
import io.github.ocelot.sonar.client.framebuffer.AdvancedFboTextureAttachment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.NativeResource;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedFbo
implements NativeResource {
    private int id = -1;
    private int width;
    private int height;
    private final AdvancedFboAttachment[] colorAttachments;
    private final AdvancedFboAttachment depthAttachment;

    private AdvancedFbo(int width, int height, AdvancedFboAttachment[] colorAttachments, @Nullable AdvancedFboAttachment depthAttachment) {
        this.width = width;
        this.height = height;
        this.colorAttachments = colorAttachments;
        this.depthAttachment = depthAttachment;
    }

    private void createRaw() {
        int status;
        for (AdvancedFboAttachment attachment : this.colorAttachments) {
            attachment.create();
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.create();
        }
        this.id = GL30.glGenFramebuffers();
        this.bind(false);
        for (int i = 0; i < this.colorAttachments.length; ++i) {
            this.colorAttachments[i].attach(36160, i);
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.attach(36160, 0);
        }
        if ((status = GL30.glCheckFramebufferStatus((int)36160)) != 36053) {
            throw new IllegalStateException("Advanced FBO status did not return GL_FRAMEBUFFER_COMPLETE. 0x" + Integer.toHexString(status));
        }
        AdvancedFbo.unbind();
    }

    public void create() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::createRaw);
        } else {
            this.createRaw();
        }
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void clear() {
        int mask = 0;
        if (this.hasColorAttachment(0)) {
            mask |= 0x4000;
        }
        if (this.hasDepthAttachment()) {
            mask |= 0x100;
        }
        GlStateManager.func_227658_a_((int)mask, (boolean)Minecraft.field_142025_a);
    }

    public void bind(boolean setViewport) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> {
                GL30.glBindFramebuffer((int)36160, (int)this.id);
                if (setViewport) {
                    RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
                }
            });
        } else {
            GL30.glBindFramebuffer((int)36160, (int)this.id);
            if (setViewport) {
                RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
            }
        }
    }

    public static void unbind() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36160, (int)0));
        } else {
            GL30.glBindFramebuffer((int)36160, (int)0);
        }
    }

    public void bindRead(boolean setViewport) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> {
                GL30.glBindFramebuffer((int)36008, (int)this.id);
                if (setViewport) {
                    RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
                }
            });
        } else {
            GL30.glBindFramebuffer((int)36008, (int)this.id);
            if (setViewport) {
                RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
            }
        }
    }

    public static void unbindRead() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36008, (int)0));
        } else {
            GL30.glBindFramebuffer((int)36008, (int)0);
        }
    }

    public void bindDraw(boolean setViewport) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> {
                GL30.glBindFramebuffer((int)36009, (int)this.id);
                if (setViewport) {
                    RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
                }
            });
        } else {
            GL30.glBindFramebuffer((int)36009, (int)this.id);
            if (setViewport) {
                RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
            }
        }
    }

    public static void unbindDraw() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36009, (int)0));
        } else {
            GL30.glBindFramebuffer((int)36009, (int)0);
        }
    }

    public void resolveToFbo(int id, int width, int height, int mask, int filtering) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> {
                this.bindRead(false);
                GL30.glBindFramebuffer((int)36009, (int)id);
                GL30.glBlitFramebuffer((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)width, (int)height, (int)mask, (int)filtering);
                AdvancedFbo.unbindDraw();
                AdvancedFbo.unbindRead();
            });
        } else {
            this.bindRead(false);
            GL30.glBindFramebuffer((int)36009, (int)id);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)width, (int)height, (int)mask, (int)filtering);
            AdvancedFbo.unbindDraw();
            AdvancedFbo.unbindRead();
        }
    }

    public void resolveToAdvancedFbo(AdvancedFbo target) {
        this.resolveToFbo(target.getId(), target.getWidth(), target.getHeight(), 16640, 9728);
    }

    public void resolveToAdvancedFbo(AdvancedFbo target, int mask, int filtering) {
        this.resolveToFbo(target.getId(), target.getWidth(), target.getHeight(), mask, filtering);
    }

    public void resolveToFrambuffer(Framebuffer target) {
        this.resolveToFbo(target.field_147616_f, target.field_147621_c, target.field_147618_d, 16640, 9728);
    }

    public void resolveToFrambuffer(Framebuffer target, int mask, int filtering) {
        this.resolveToFbo(target.field_147616_f, target.field_147621_c, target.field_147618_d, mask, filtering);
    }

    public void resolveToScreen() {
        this.resolveToScreen(16384, 9728);
    }

    public void resolveToScreen(int mask, int filtering) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> {
                MainWindow window = Minecraft.func_71410_x().func_228018_at_();
                this.bindRead(false);
                AdvancedFbo.unbindDraw();
                GL30.glDrawBuffer((int)1029);
                GL30.glBlitFramebuffer((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)window.func_198109_k(), (int)window.func_198091_l(), (int)mask, (int)filtering);
                AdvancedFbo.unbindRead();
            });
        } else {
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            this.bindRead(false);
            AdvancedFbo.unbindDraw();
            GL30.glDrawBuffer((int)1029);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)window.func_198109_k(), (int)window.func_198091_l(), (int)mask, (int)filtering);
            AdvancedFbo.unbindRead();
        }
    }

    public void free() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> {
                if (this.id != -1) {
                    GL30.glDeleteFramebuffers((int)this.id);
                    this.id = -1;
                }
                for (AdvancedFboAttachment attachment : this.colorAttachments) {
                    attachment.free();
                }
                if (this.depthAttachment != null) {
                    this.depthAttachment.free();
                }
            });
        } else {
            if (this.id != -1) {
                GL30.glDeleteFramebuffers((int)this.id);
                this.id = -1;
            }
            for (AdvancedFboAttachment attachment : this.colorAttachments) {
                attachment.free();
            }
            if (this.depthAttachment != null) {
                this.depthAttachment.free();
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColorAttachments() {
        return this.colorAttachments.length;
    }

    public boolean hasColorAttachment(int attachment) {
        return attachment >= 0 && attachment < this.colorAttachments.length;
    }

    public boolean hasDepthAttachment() {
        return this.depthAttachment != null;
    }

    public AdvancedFboAttachment getColorAttachment(int attachment) {
        Validate.isTrue((boolean)this.hasColorAttachment(attachment), (String)("Color attachment " + attachment + " does not exist."), (Object[])new Object[0]);
        return this.colorAttachments[attachment];
    }

    public boolean isColorTextureAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboTextureAttachment;
    }

    public AdvancedFboTextureAttachment getColorTextureAttachment(int attachment) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isColorTextureAttachment(attachment), (String)("Color attachment " + attachment + " must be a texture attachment to modify texture information."), (Object[])new Object[0]);
        return (AdvancedFboTextureAttachment)advancedFboAttachment;
    }

    public AdvancedFboAttachment getDepthAttachment() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        Validate.isTrue((boolean)this.hasDepthAttachment(), (String)"Depth attachment does not exist.", (Object[])new Object[0]);
        return Objects.requireNonNull(this.depthAttachment);
    }

    public boolean isDepthTextureAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboTextureAttachment;
    }

    public AdvancedFboTextureAttachment getDepthTextureAttachment() {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthTextureAttachment(), (String)"Depth attachment must be a texture attachment to modify texture information.", (Object[])new Object[0]);
        return (AdvancedFboTextureAttachment)advancedFboAttachment;
    }

    public Wrapper getVanillaWrapper() {
        return new Wrapper(this);
    }

    public static class Wrapper
    extends Framebuffer {
        private final AdvancedFbo fbo;

        private Wrapper(AdvancedFbo fbo) {
            super(fbo.width, fbo.height, fbo.hasDepthAttachment(), Minecraft.field_142025_a);
            this.fbo = fbo;
            this.func_216492_b(this.fbo.getWidth(), this.fbo.getHeight(), Minecraft.field_142025_a);
        }

        public void func_216491_a(int width, int height, boolean onMac) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.func_216492_b(width, height, onMac));
            } else {
                this.func_216492_b(width, height, onMac);
            }
        }

        public void func_147608_a() {
            this.fbo.close();
        }

        public void func_216492_b(int width, int height, boolean onMac) {
            this.field_147621_c = width;
            this.field_147618_d = height;
            if (this.fbo == null) {
                return;
            }
            this.fbo.setSize(width, height);
            AdvancedFboAttachment attachment = this.fbo.hasColorAttachment(0) ? this.fbo.getColorAttachment(0) : null;
            this.field_147622_a = attachment == null ? this.field_147621_c : attachment.getWidth();
            this.field_147620_b = attachment == null ? this.field_147618_d : attachment.getHeight();
        }

        public void func_147607_a(int framebufferFilter) {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            this.field_147623_j = framebufferFilter;
            for (int i = 0; i < this.fbo.getColorAttachments(); ++i) {
                this.fbo.getColorAttachment(i).bind();
                GlStateManager.func_227677_b_((int)3553, (int)10241, (int)framebufferFilter);
                GlStateManager.func_227677_b_((int)3553, (int)10240, (int)framebufferFilter);
                GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10496);
                GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10496);
                this.fbo.getColorAttachment(i).unbind();
            }
        }

        public void func_147612_c() {
            if (this.fbo.hasColorAttachment(0)) {
                this.fbo.getColorAttachment(0).bind();
            }
        }

        public void func_147606_d() {
            if (this.fbo.hasColorAttachment(0)) {
                this.fbo.getColorAttachment(0).unbind();
            }
        }

        public void func_147610_a(boolean setViewport) {
            this.fbo.bind(setViewport);
        }

        public AdvancedFbo getFbo() {
            return this.fbo;
        }
    }

    public static class Builder {
        private final int width;
        private final int height;
        private final List<AdvancedFboAttachment> colorAttachments;
        private AdvancedFboAttachment depthAttachment;

        public Builder(int width, int height) {
            this.width = width;
            this.height = height;
            this.colorAttachments = new ArrayList<AdvancedFboAttachment>();
            this.depthAttachment = null;
        }

        public Builder(AdvancedFbo parent) {
            this(parent.getWidth(), parent.getHeight());
            this.addAttachments(parent);
        }

        public Builder(Framebuffer parent) {
            this(parent.field_147621_c, parent.field_147618_d);
            this.addAttachments(parent);
        }

        private void validateColorSize() {
            Validate.inclusiveBetween((long)0L, (long)GL30.glGetInteger((int)36063), (long)this.colorAttachments.size());
        }

        public Builder addAttachments(AdvancedFbo parent) {
            for (int i = 0; i < parent.getColorAttachments(); ++i) {
                this.colorAttachments.add(parent.getColorAttachment(i).createCopy());
            }
            this.validateColorSize();
            if (parent.hasDepthAttachment()) {
                Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
                this.depthAttachment = parent.getDepthAttachment().createCopy();
            }
            return this;
        }

        public Builder addAttachments(Framebuffer parent) {
            this.addColorTextureBuffer(parent.field_147622_a, parent.field_147620_b, 0);
            if (parent.field_147619_e) {
                Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
                this.setDepthRenderBuffer(parent.field_147622_a, parent.field_147620_b, 1);
            }
            return this;
        }

        public Builder addColorTextureBuffer() {
            this.addColorTextureBuffer(this.width, this.height, 0);
            return this;
        }

        public Builder addColorTextureBuffer(int mipmapLevels) {
            this.addColorTextureBuffer(this.width, this.height, mipmapLevels);
            return this;
        }

        public Builder addColorTextureBuffer(int width, int height, int mipmapLevels) {
            this.colorAttachments.add(new AdvancedFboAttachmentColorTexture2D(width, height, mipmapLevels));
            this.validateColorSize();
            return this;
        }

        public Builder addColorRenderBuffer() {
            this.addColorRenderBuffer(this.width, this.height, 1);
            return this;
        }

        public Builder addColorRenderBuffer(int samples) {
            this.addColorRenderBuffer(this.width, this.height, samples);
            return this;
        }

        public Builder addColorRenderBuffer(int width, int height, int samples) {
            this.colorAttachments.add(new AdvancedFboAttachmentColorRenderBuffer(width, height, samples));
            this.validateColorSize();
            return this;
        }

        public Builder setDepthTextureBuffer() {
            this.setDepthTextureBuffer(this.width, this.height, 0);
            return this;
        }

        public Builder setDepthTextureBuffer(int mipmapLevels) {
            this.setDepthTextureBuffer(this.width, this.height, mipmapLevels);
            return this;
        }

        public Builder setDepthTextureBuffer(int width, int height, int mipmapLevels) {
            Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
            this.depthAttachment = new AdvancedFboAttachmentDepthTexture2D(width, height, mipmapLevels);
            return this;
        }

        public Builder setDepthRenderBuffer() {
            this.setDepthRenderBuffer(this.width, this.height, 1);
            return this;
        }

        public Builder setDepthRenderBuffer(int samples) {
            this.setDepthRenderBuffer(this.width, this.height, samples);
            return this;
        }

        public Builder setDepthRenderBuffer(int width, int height, int samples) {
            Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
            this.depthAttachment = new AdvancedFboAttachmentDepthRenderBuffer(width, height, samples);
            return this;
        }

        public AdvancedFbo build() {
            if (this.colorAttachments.isEmpty()) {
                throw new IllegalArgumentException("Framebuffer needs at least one color attachment to be complete.");
            }
            int samples = -1;
            for (AdvancedFboAttachment attachment : this.colorAttachments) {
                if (samples == -1) {
                    samples = attachment.getSamples();
                    continue;
                }
                if (attachment.getSamples() == samples) continue;
                throw new IllegalArgumentException("Framebuffer attachments need to have the same number of samples to be complete.");
            }
            if (this.depthAttachment != null && this.depthAttachment.getSamples() != samples) {
                throw new IllegalArgumentException("Framebuffer attachments need to have the same number of samples to be complete.");
            }
            return new AdvancedFbo(this.width, this.height, this.colorAttachments.toArray(new AdvancedFboAttachment[0]), this.depthAttachment);
        }
    }
}

