/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.network;

import io.github.ocelot.sonar.common.network.message.SonarLoginMessage;
import io.github.ocelot.sonar.common.network.message.SonarMessage;
import io.netty.util.concurrent.Future;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SonarNetworkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimpleChannel channel;
    private final LazyValue<Supplier<Object>> clientMessageHandler;
    private final LazyValue<Supplier<Object>> serverMessageHandler;
    private int nextId;

    public SonarNetworkManager(SimpleChannel channel, Supplier<Supplier<Object>> clientSupplier, Supplier<Supplier<Object>> serverSupplier) {
        this.channel = channel;
        this.clientMessageHandler = new LazyValue(clientSupplier);
        this.serverMessageHandler = new LazyValue(serverSupplier);
    }

    private <MSG extends SonarMessage<T>, T> boolean processMessage(MSG msg, Supplier<NetworkEvent.Context> ctx) {
        try {
            msg.processPacket(ctx.get().getDirection().getReceptionSide().isClient() ? ((Supplier)this.clientMessageHandler.func_179281_c()).get() : ((Supplier)this.serverMessageHandler.func_179281_c()).get(), ctx.get());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to process packet for class: " + msg.getClass().getName(), (Throwable)e);
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                TranslationTextComponent textComponent = new TranslationTextComponent("disconnect.genericReason", new Object[]{"Internal Exception: " + e});
                NetworkManager networkManager = ctx.get().getNetworkManager();
                networkManager.func_201058_a((IPacket)new SDisconnectPacket((ITextComponent)textComponent), arg_0 -> SonarNetworkManager.lambda$processMessage$0(networkManager, (ITextComponent)textComponent, arg_0));
                networkManager.func_150721_g();
            }
            return false;
        }
    }

    private <MSG extends SonarMessage<T>, T> SimpleChannel.MessageBuilder<MSG> getMessageBuilder(Class<MSG> clazz, Supplier<MSG> generator, @Nullable NetworkDirection direction) {
        return this.channel.messageBuilder(clazz, this.nextId++, direction).encoder(SonarMessage::writePacketData).decoder(buf -> {
            SonarMessage msg = (SonarMessage)generator.get();
            msg.readPacketData((PacketBuffer)buf);
            return msg;
        }).consumer(this::processMessage);
    }

    public <MSG extends SonarMessage<T>, T> void register(Class<MSG> clazz, Supplier<MSG> generator, @Nullable NetworkDirection direction) {
        this.getMessageBuilder(clazz, generator, direction).add();
    }

    public <MSG extends SonarLoginMessage<T>, T> void registerLoginReply(Class<MSG> clazz, Supplier<MSG> generator, @Nullable NetworkDirection direction) {
        this.channel.messageBuilder(clazz, this.nextId++, direction).encoder(SonarMessage::writePacketData).decoder(buf -> {
            SonarLoginMessage msg = (SonarLoginMessage)generator.get();
            msg.readPacketData((PacketBuffer)buf);
            return msg;
        }).consumer(FMLHandshakeHandler.indexFirst((__, msg, ctx) -> ((NetworkEvent.Context)ctx.get()).setPacketHandled(this.processMessage((SonarMessage)msg, (Supplier<NetworkEvent.Context>)ctx)))).loginIndex(SonarLoginMessage::getAsInt, SonarLoginMessage::setLoginIndex).add();
    }

    public <MSG extends SonarLoginMessage<T>, T> void registerLogin(Class<MSG> clazz, Supplier<MSG> generator, @Nullable NetworkDirection direction) {
        this.getMessageBuilder(clazz, generator, direction).loginIndex(SonarLoginMessage::getAsInt, SonarLoginMessage::setLoginIndex).markAsLoginPacket().add();
    }

    public <MSG extends SonarLoginMessage<T>, T> void registerLogin(Class<MSG> clazz, Supplier<MSG> generator, Function<Boolean, List<Pair<String, MSG>>> loginPacketGenerators, @Nullable NetworkDirection direction) {
        this.getMessageBuilder(clazz, generator, direction).loginIndex(SonarLoginMessage::getAsInt, SonarLoginMessage::setLoginIndex).buildLoginPacketList(loginPacketGenerators).add();
    }

    private static /* synthetic */ void lambda$processMessage$0(NetworkManager networkManager, ITextComponent textComponent, Future future) throws Exception {
        networkManager.func_150718_a(textComponent);
    }
}

