/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public abstract class DynamicInventory
implements IInventory {
    private final Int2ObjectOpenHashMap<ItemStack> inventory = new Int2ObjectOpenHashMap();
    private Set<IInventoryChangedListener> listeners = null;

    private int getNextEmptySlot(ItemStack stack, int loopStart, int loopEnd) {
        for (int i = loopStart; i < loopEnd; ++i) {
            if (!this.func_94041_b(i, stack) || !((ItemStack)this.inventory.getOrDefault(i, (Object)ItemStack.field_190927_a)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private void mergeStacks(ItemStack stack, ItemStack stackInSlot, int index) {
        int maxStackSize = Math.min(this.getSlotStackLimit(index), stackInSlot.func_77976_d());
        int addAmount = Math.min(stack.func_190916_E(), maxStackSize - stackInSlot.func_190916_E());
        if (addAmount > 0) {
            stackInSlot.func_190917_f(addAmount);
            stack.func_190918_g(addAmount);
        }
    }

    public void addListener(IInventoryChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<IInventoryChangedListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IInventoryChangedListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public ItemStack addItem(ItemStack stack) {
        return this.addItem(stack, 0, this.func_70302_i_());
    }

    public ItemStack addItem(ItemStack stack, int startIndex, int endIndex) {
        int index;
        int loopStart = Math.max(0, startIndex);
        int loopEnd = Math.min(this.func_70302_i_(), endIndex);
        ItemStack copy = stack.func_77946_l();
        for (int i = loopStart; i < loopEnd; ++i) {
            ItemStack stackInSlot = this.func_70301_a(i);
            if (!this.func_94041_b(i, stack) || !ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)copy) || !ItemStack.func_77970_a((ItemStack)stackInSlot, (ItemStack)copy)) continue;
            this.mergeStacks(copy, stackInSlot, i);
            if (!copy.func_190926_b()) continue;
            this.func_70296_d();
            return ItemStack.field_190927_a;
        }
        while (!copy.func_190926_b() && (index = this.getNextEmptySlot(copy, loopStart, loopEnd)) >= 0) {
            if (copy.func_190916_E() > this.getSlotStackLimit(index)) {
                this.inventory.put(index, (Object)copy.func_77979_a(this.getSlotStackLimit(index)));
                continue;
            }
            this.inventory.put(index, (Object)copy.func_77946_l());
            copy = ItemStack.field_190927_a;
        }
        if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)copy)) {
            this.func_70296_d();
        }
        return copy;
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.field_190927_a)).func_190926_b() || count <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.field_190927_a)).func_77979_a(count);
        this.func_70296_d();
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        if (((ItemStack)this.inventory.getOrDefault(index, (Object)ItemStack.field_190927_a)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = (ItemStack)this.inventory.remove(index);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < 0 || index >= this.func_70302_i_()) {
            return;
        }
        this.inventory.put(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.getSlotStackLimit(index)) {
            stack.func_190920_e(this.getSlotStackLimit(index));
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (this.listeners == null) {
            return;
        }
        for (IInventoryChangedListener listener : this.listeners) {
            listener.func_76316_a((IInventory)this);
        }
    }

    public int getSlotStackLimit(int index) {
        return this.func_70297_j_();
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void write(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.getOrDefault(i, (Object)ItemStack.field_190927_a);
            if (stack.func_190926_b()) continue;
            CompoundNBT slotNbt = new CompoundNBT();
            slotNbt.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(slotNbt);
            list.add((Object)slotNbt);
        }
        nbt.func_218657_a("Items", (INBT)list);
    }

    public void read(CompoundNBT nbt) {
        this.func_174888_l();
        ListNBT list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT slotNbt = list.func_150305_b(i);
            int index = slotNbt.func_74771_c("Slot") & 0xFF;
            if (index >= this.func_70302_i_()) continue;
            this.inventory.put(index, (Object)ItemStack.func_199557_a((CompoundNBT)slotNbt));
        }
    }
}

