/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.valuecontainer;

import io.github.ocelot.sonar.common.valuecontainer.NumberValueContainerEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class IntValueContainerEntry
extends NumberValueContainerEntry<Integer> {
    private final ITextComponent displayName;
    private boolean bounds;

    public IntValueContainerEntry(ITextComponent displayName, String name, int value) {
        this(displayName, name, value, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.bounds = false;
    }

    public IntValueContainerEntry(ITextComponent displayName, String name, int value, int minValue, int maxValue) {
        super(name, value, minValue, maxValue);
        this.displayName = displayName;
        this.bounds = true;
    }

    @Override
    protected Integer getValue(Number number) {
        return number.intValue();
    }

    @Override
    protected Integer clamp(Integer value, Integer minValue, Integer maxValue) {
        if (value < minValue) {
            value = minValue;
        }
        if (value > maxValue) {
            value = maxValue;
        }
        return value;
    }

    @Override
    protected boolean hasBounds() {
        return this.bounds;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74768_a(this.getName(), ((Integer)this.value).intValue());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 3) ? Integer.valueOf(nbt.func_74762_e(this.getName())) : (Integer)this.getPreviousValue();
    }

    @Override
    public boolean isDecimal() {
        return false;
    }
}

