/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.valuecontainer;

import io.github.ocelot.sonar.common.valuecontainer.SliderEntry;
import io.github.ocelot.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class NumberValueContainerEntry<T extends Number>
implements ValueContainerEntry<T>,
SliderEntry {
    private final String name;
    private final T minValue;
    private final T maxValue;
    private final T previousValue;
    protected T value;
    private Predicate<String> validator;
    private boolean percentage;

    public NumberValueContainerEntry(String name, T value, T minValue, T maxValue) {
        this.name = name;
        this.previousValue = value;
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.validator = NumberValueContainerEntry.createDefaultValidator(this);
    }

    protected abstract T getValue(Number var1);

    protected abstract T clamp(T var1, T var2, T var3);

    protected abstract boolean hasBounds();

    @Override
    public String getName() {
        return this.name;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    @Override
    public <E> E getValue() {
        return (E)this.value;
    }

    @Override
    public <E> E getPreviousValue() {
        return (E)this.previousValue;
    }

    @Override
    public ValueContainerEntry.InputType getInputType() {
        return this.hasBounds() ? ValueContainerEntry.InputType.SLIDER : ValueContainerEntry.InputType.TEXT_FIELD;
    }

    @Override
    public boolean isDirty() {
        return !Objects.equals(this.value, this.previousValue);
    }

    @Override
    public String getDisplay() {
        return String.valueOf(this.value);
    }

    @Override
    public void parse(String data) {
        this.value = this.clamp(this.getValue(NumberUtils.createNumber((String)data.trim())), this.minValue, this.maxValue);
    }

    @Override
    public double getSliderValue() {
        return ((Number)this.getValue()).doubleValue();
    }

    @Override
    public double getMinSliderValue() {
        return ((Number)this.getMinValue()).doubleValue();
    }

    @Override
    public double getMaxSliderValue() {
        return ((Number)this.getMaxValue()).doubleValue();
    }

    @Override
    public boolean isPercentage() {
        return this.percentage;
    }

    public NumberValueContainerEntry<T> setPercentage(boolean percentage) {
        this.percentage = percentage;
        return this;
    }

    @Override
    public Optional<Predicate<String>> getValidator() {
        return Optional.ofNullable(this.validator);
    }

    public NumberValueContainerEntry<T> setValidator(@Nullable Predicate<String> validator) {
        this.validator = validator;
        return this;
    }

    public static Predicate<String> createDefaultValidator(NumberValueContainerEntry<?> entry) {
        return s -> !StringUtils.isEmpty((CharSequence)s.trim()) && NumberUtils.isCreatable((String)s.trim());
    }
}

