/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.entity.boat;

import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.BYGEntities;
import corgiaoc.byg.core.BYGItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BYGBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> BYG_BOAT_TYPE = EntityDataManager.func_187226_a(BYGBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public BYGBoatEntity(World worldIn, double x, double y, double z) {
        this(BYGEntities.BOAT, worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public BYGBoatEntity(EntityType<? extends BoatEntity> boatEntityType, World worldType) {
        super(boatEntityType, worldType);
    }

    public BYGBoatEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super(BYGEntities.BOAT, world);
    }

    public Item func_184455_j() {
        switch (this.getBYGBoatType()) {
            default: {
                return BYGItems.ASPEN_BOAT;
            }
            case BAOBAB: {
                return BYGItems.BAOBAB_BOAT;
            }
            case BLUE_ENCHANTED: {
                return BYGItems.BLUE_ENCHANTED_BOAT;
            }
            case CHERRY: {
                return BYGItems.CHERRY_BOAT;
            }
            case CIKA: {
                return BYGItems.CIKA_BOAT;
            }
            case CYPRESS: {
                return BYGItems.CYPRESS_BOAT;
            }
            case EBONY: {
                return BYGItems.EBONY_BOAT;
            }
            case FIR: {
                return BYGItems.FIR_BOAT;
            }
            case GREEN_ENCHANTED: {
                return BYGItems.GREEN_ENCHANTED_BOAT;
            }
            case HOLLY: {
                return BYGItems.HOLLY_BOAT;
            }
            case JACARANDA: {
                return BYGItems.JACARANDA_BOAT;
            }
            case MAHOGANY: {
                return BYGItems.MAHOGANY_BOAT;
            }
            case MANGROVE: {
                return BYGItems.MANGROVE_BOAT;
            }
            case MAPLE: {
                return BYGItems.MAPLE_BOAT;
            }
            case PINE: {
                return BYGItems.PINE_BOAT;
            }
            case RAINBOW_EUCALYPTUS: {
                return BYGItems.RAINBOW_EUCALYPTUS_BOAT;
            }
            case REDWOOD: {
                return BYGItems.REDWOOD_BOAT;
            }
            case SKYRIS: {
                return BYGItems.SKYRIS_BOAT;
            }
            case WILLOW: {
                return BYGItems.WILLOW_BOAT;
            }
            case WITCH_HAZEL: {
                return BYGItems.WITCH_HAZEL_BOAT;
            }
            case ZELKOVA: {
                return BYGItems.ZELKOVA_BOAT;
            }
            case PALM: 
        }
        return BYGItems.PALM_BOAT;
    }

    public Block getPlanks() {
        switch (this.getBYGBoatType()) {
            default: {
                return BYGBlocks.ASPEN_PLANKS;
            }
            case BAOBAB: {
                return BYGBlocks.BAOBAB_PLANKS;
            }
            case BLUE_ENCHANTED: {
                return BYGBlocks.BLUE_ENCHANTED_PLANKS;
            }
            case CHERRY: {
                return BYGBlocks.CHERRY_PLANKS;
            }
            case CIKA: {
                return BYGBlocks.CIKA_PLANKS;
            }
            case CYPRESS: {
                return BYGBlocks.CYPRESS_PLANKS;
            }
            case EBONY: {
                return BYGBlocks.EBONY_PLANKS;
            }
            case FIR: {
                return BYGBlocks.FIR_PLANKS;
            }
            case GREEN_ENCHANTED: {
                return BYGBlocks.GREEN_ENCHANTED_PLANKS;
            }
            case HOLLY: {
                return BYGBlocks.HOLLY_PLANKS;
            }
            case JACARANDA: {
                return BYGBlocks.JACARANDA_PLANKS;
            }
            case MAHOGANY: {
                return BYGBlocks.MAHOGANY_PLANKS;
            }
            case MANGROVE: {
                return BYGBlocks.MANGROVE_PLANKS;
            }
            case MAPLE: {
                return BYGBlocks.MAPLE_PLANKS;
            }
            case PALM: {
                return BYGBlocks.PALM_PLANKS;
            }
            case PINE: {
                return BYGBlocks.PINE_PLANKS;
            }
            case RAINBOW_EUCALYPTUS: {
                return BYGBlocks.RAINBOW_EUCALYPTUS_PLANKS;
            }
            case REDWOOD: {
                return BYGBlocks.REDWOOD_PLANKS;
            }
            case SKYRIS: {
                return BYGBlocks.SKYRIS_PLANKS;
            }
            case WILLOW: {
                return BYGBlocks.WILLOW_PLANKS;
            }
            case WITCH_HAZEL: {
                return BYGBlocks.WITCH_HAZEL_PLANKS;
            }
            case ZELKOVA: 
        }
        return BYGBlocks.ZELKOVA_PLANKS;
    }

    public BYGType getBYGBoatType() {
        return BYGType.byId((Integer)this.field_70180_af.func_187225_a(BYG_BOAT_TYPE));
    }

    public void setBYGBoatType(BYGType boatBYGType) {
        this.field_70180_af.func_187227_b(BYG_BOAT_TYPE, (Object)boatBYGType.ordinal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BYG_BOAT_TYPE, (Object)BYGType.ASPEN.ordinal());
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("BYGType", this.getBYGBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("BYGType", 8)) {
            this.setBYGBoatType(BYGType.getTypeFromString(compound.func_74779_i("BYGType")));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.func_70269_c(-this.func_70267_i());
        this.func_70265_b(10);
        this.func_70266_a(this.func_70271_g() * 11.0f);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != BoatEntity.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            for (int i = 0; i < 3; ++i) {
                                this.func_199703_a((IItemProvider)this.getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_199703_a((IItemProvider)Items.field_151055_y);
                            }
                            this.func_199703_a((IItemProvider)Blocks.field_150350_a);
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70271_g() > 40.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a((IItemProvider)this.func_184455_j());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum BYGType {
        ASPEN("aspen"),
        BAOBAB("baobab"),
        BLUE_ENCHANTED("blue_enchanted"),
        CHERRY("cherry"),
        CIKA("cika"),
        CYPRESS("cypress"),
        EBONY("ebony"),
        FIR("fir"),
        GREEN_ENCHANTED("green_enchanted"),
        HOLLY("holly"),
        JACARANDA("jacaranda"),
        MAHOGANY("mahogony"),
        MANGROVE("mangrove"),
        MAPLE("maple"),
        PALM("palm"),
        PINE("pine"),
        RAINBOW_EUCALYPTUS("rainbow_eucalyptus"),
        REDWOOD("redwood"),
        SKYRIS("skyris"),
        WILLOW("willow"),
        WITCH_HAZEL("witch_hazel"),
        ZELKOVA("zelkova");

        private final String name;

        private BYGType(String string2) {
            this.name = string2;
        }

        public static BYGType byId(int id) {
            BYGType[] aBYGBoatEntity$BYGType = BYGType.values();
            if (id < 0 || id >= aBYGBoatEntity$BYGType.length) {
                id = 0;
            }
            return aBYGBoatEntity$BYGType[id];
        }

        public static BYGType getTypeFromString(String nameIn) {
            BYGType[] aBYGBoatEntity$BYGType;
            for (BYGType BYGType2 : aBYGBoatEntity$BYGType = BYGType.values()) {
                if (!BYGType2.getName().equals(nameIn)) continue;
                return BYGType2;
            }
            return aBYGBoatEntity$BYGType[0];
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

