/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.nether;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.nether.BYGNetherLayerProvider;
import corgiaoc.byg.config.BYGWorldConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;

public class BYGNetherBiomeProvider
extends BiomeProvider {
    public static final Codec<BYGNetherBiomeProvider> BYGNETHERCODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGNetherBiomeProvider::new)));
    private static final List<String> NETHER_BIOME_IDS = Arrays.asList(((String)BYGWorldConfig.BLACKLIST_NETHER.get()).trim().replace(" ", "").split(","));
    private final DatapackLayer biomeLayer;
    private final long seed;
    private final Registry<Biome> biomeRegistry;
    public static List<ResourceLocation> NETHER_BIOMES = new ArrayList<ResourceLocation>();

    public BYGNetherBiomeProvider(Registry<Biome> registry, long seed) {
        super(BYGNetherBiomeProvider.createNetherBiomeList(registry).stream().map(arg_0 -> registry.func_82594_a(arg_0)).collect(Collectors.toList()));
        this.seed = seed;
        this.biomeRegistry = registry;
        NETHER_BIOMES = BYGNetherBiomeProvider.createNetherBiomeList(registry);
        this.biomeLayer = BYGNetherLayerProvider.stackLayers(this.biomeRegistry, seed);
    }

    public static List<ResourceLocation> createNetherBiomeList(Registry<Biome> biomeRegistry) {
        ArrayList<ResourceLocation> NETHER_BIOMES = new ArrayList<ResourceLocation>();
        for (Map.Entry biomeEntry : biomeRegistry.func_239659_c_()) {
            if (((Biome)biomeEntry.getValue()).func_201856_r() != Biome.Category.NETHER) continue;
            ResourceLocation locationKey = ((RegistryKey)biomeEntry.getKey()).func_240901_a_();
            if (((Boolean)BYGWorldConfig.IS_BLACKLIST_NETHER.get()).booleanValue()) {
                if (NETHER_BIOMES.contains(locationKey) || NETHER_BIOME_IDS.contains(locationKey.toString())) continue;
                NETHER_BIOMES.add(locationKey);
                continue;
            }
            for (String id : NETHER_BIOME_IDS) {
                if (!id.equals(locationKey.toString())) continue;
                NETHER_BIOMES.add(locationKey);
            }
        }
        NETHER_BIOMES.removeIf(Objects::isNull);
        return NETHER_BIOMES;
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return BYGNETHERCODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new BYGNetherBiomeProvider(this.biomeRegistry, seed);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.biomeLayer.sampleNether(this.biomeRegistry, x, z);
    }
}

