/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class RiverThingy
extends Feature<NoFeatureConfig> {
    FastNoise fastNoise = null;
    FastNoise fastNoise2 = null;
    FastNoise fastNoise3 = null;

    public RiverThingy(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        this.setSeed(worldIn.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int multiplier = 15;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(pos.func_177958_n() + x, 0, pos.func_177952_p() + z);
                double noise = this.fastNoise.GetNoise(mutable.func_177958_n(), mutable.func_177952_p());
                double noise2 = Math.abs(this.fastNoise2.GetNoise(mutable.func_177958_n(), mutable.func_177952_p()) + 1.0f) * 3.0f;
                double noise3 = Math.abs(this.fastNoise3.GetNoise(mutable.func_177958_n(), mutable.func_177952_p()) + 1.0f) * 4.0f;
                if (!(noise > 0.85)) continue;
                int maximumHeight = (int)(noise3 * 2.0) + worldIn.func_181545_F();
                int minimumHeight = (int)(10.0 + noise2 * 3.0);
                mutable.func_189534_c(Direction.UP, maximumHeight);
                for (int y = maximumHeight; y >= minimumHeight; --y) {
                    worldIn.func_180501_a((BlockPos)mutable, Blocks.field_150350_a.func_176223_P(), 2);
                    mutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fastNoise == null) {
            this.fastNoise = new FastNoise((int)seed);
            this.fastNoise.SetFractalType(FastNoise.FractalType.RigidMulti);
            this.fastNoise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.fastNoise.SetGradientPerturbAmp(1.0f);
            this.fastNoise.SetFractalOctaves(1);
            this.fastNoise.SetFractalGain(0.3f);
            this.fastNoise.SetFrequency(0.00375f);
        }
        if (this.fastNoise2 == null) {
            this.fastNoise2 = new FastNoise((int)seed);
            this.fastNoise2.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            this.fastNoise2.SetGradientPerturbAmp(1.0f);
            this.fastNoise2.SetFractalOctaves(1);
            this.fastNoise2.SetFractalGain(0.3f);
            this.fastNoise2.SetFrequency(0.0575f);
        }
        if (this.fastNoise3 == null) {
            this.fastNoise3 = new FastNoise((int)seed);
            this.fastNoise3.SetNoiseType(FastNoise.NoiseType.Perlin);
            this.fastNoise3.SetGradientPerturbAmp(1.0f);
            this.fastNoise3.SetFractalOctaves(1);
            this.fastNoise3.SetFractalGain(0.3f);
            this.fastNoise3.SetFrequency(0.07675f);
        }
    }
}

