/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.volcano;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.SimpleBlockProviderConfig;
import corgiaoc.byg.util.noise.fastnoise.lite.FastNoiseLite;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class VolcanoFeature
extends Feature<SimpleBlockProviderConfig> {
    FastNoiseLite fnlPerlin = null;

    public VolcanoFeature(Codec<SimpleBlockProviderConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.func_72905_C());
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151579_a || world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151587_i || world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n(), pos.func_177952_p()) < 4) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        double baseRadius = 15.0;
        double lavaLeakage = 0.7;
        int volcanoConeSize = 75;
        int volcanoStartHeight = volcanoConeSize - 5;
        double threshold = 0.5;
        for (double x = (double)(-volcanoConeSize); x <= (double)volcanoConeSize; x += 1.0) {
            for (double y = (double)(-volcanoConeSize); y <= -15.0; y += 1.0) {
                for (double z = (double)(-volcanoConeSize); z <= (double)volcanoConeSize; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y + volcanoStartHeight, (int)z);
                    float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.func_177958_n(), mutable.func_177952_p()));
                    double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                    if (scaledNoise - lavaLeakage >= threshold) {
                        if (mutable.func_177956_o() > pos.func_177956_o() + (volcanoStartHeight - 19)) continue;
                        world.func_180501_a((BlockPos)mutable, Blocks.field_150353_l.func_176223_P(), 2);
                        world.func_205219_F_().func_205360_a((BlockPos)mutable, (Object)Fluids.field_204547_b, 0);
                        continue;
                    }
                    if (!(scaledNoise >= threshold)) continue;
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

