/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.surfacebuilder;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import corgiaoc.byg.core.BYGBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class ShatteredGlacierSB
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static final BlockState PACKED_ICE = BYGBlocks.PACKED_BLACK_ICE.func_176223_P();
    private static final BlockState BLUE_ICE = BYGBlocks.BLACK_ICE.func_176223_P();
    private static final BlockState PACKED_ICE2 = BYGBlocks.PACKED_BLACK_ICE.func_176223_P();
    private static final BlockState BLUE_ICE2 = BYGBlocks.BLACK_ICE.func_176223_P();
    private static final BlockState PACKED_ICE3 = BYGBlocks.PACKED_BLACK_ICE.func_176223_P();
    private static final BlockState BLUE_ICE3 = BYGBlocks.BLACK_ICE.func_176223_P();
    private static final BlockState PACKED_ICE4 = BYGBlocks.PACKED_BLACK_ICE.func_176223_P();
    protected BlockState[] blockState;
    protected long seed;
    protected PerlinNoiseGenerator perlin1;
    protected PerlinNoiseGenerator perlin2;
    protected PerlinNoiseGenerator perlin3;

    public ShatteredGlacierSB(Codec<SurfaceBuilderConfig> config) {
        super(config);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        int chunkX = x & 0xF;
        int chunkZ = z & 0xF;
        BlockState blockstate = PACKED_ICE;
        BlockState blockstate1 = biomeIn.func_242440_e().func_242502_e().func_204109_b();
        int k = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        boolean flag = Math.cos(noise / 3.0 * Math.PI) > 0.0;
        int l = -1;
        boolean flag1 = false;
        int i1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int chunkY = startHeight; chunkY >= 0; --chunkY) {
            if (i1 >= 15) continue;
            blockpos$mutable.func_181079_c(chunkX, chunkY, chunkZ);
            BlockState blockstate2 = chunkIn.func_180495_p((BlockPos)blockpos$mutable);
            if (blockstate2.func_196958_f()) {
                l = -1;
                continue;
            }
            if (blockstate2.func_177230_c() != defaultBlock.func_177230_c()) continue;
            if (l == -1) {
                flag1 = false;
                if (k <= 0) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    blockstate1 = defaultBlock;
                } else if (chunkY >= seaLevel - 4 && chunkY <= seaLevel + 1) {
                    blockstate = PACKED_ICE;
                    blockstate1 = biomeIn.func_242440_e().func_242502_e().func_204109_b();
                }
                if (chunkY < seaLevel && (blockstate == null || blockstate.func_196958_f())) {
                    blockstate = defaultFluid;
                }
                l = k + Math.max(0, chunkY - seaLevel);
                if (chunkY >= seaLevel - 1) {
                    if (chunkY > seaLevel + 3 + k) {
                        BlockState blockstate3 = chunkY >= 64 && chunkY <= 127 ? (flag ? PACKED_ICE2 : this.noiseBlockState(x, chunkY, z)) : BLUE_ICE;
                        chunkIn.func_177436_a((BlockPos)blockpos$mutable, blockstate3, false);
                    } else {
                        chunkIn.func_177436_a((BlockPos)blockpos$mutable, biomeIn.func_242440_e().func_242502_e().func_204108_a(), false);
                        flag1 = true;
                    }
                } else {
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable, blockstate1, false);
                    Block block = blockstate1.func_177230_c();
                    if (block == Blocks.field_196777_fo || block == Blocks.field_196778_fp || block == Blocks.field_196780_fq || block == Blocks.field_196782_fr || block == Blocks.field_196783_fs || block == Blocks.field_196785_ft || block == Blocks.field_196787_fu || block == Blocks.field_196789_fv || block == Blocks.field_196791_fw || block == Blocks.field_196793_fx || block == Blocks.field_196795_fy || block == Blocks.field_196797_fz || block == Blocks.field_196719_fA || block == Blocks.field_196720_fB || block == Blocks.field_196721_fC || block == Blocks.field_196722_fD) {
                        chunkIn.func_177436_a((BlockPos)blockpos$mutable, BLUE_ICE, false);
                    }
                }
            } else if (l > 0) {
                --l;
                if (flag1) {
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable, BLUE_ICE, false);
                } else {
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable, this.noiseBlockState(x, chunkY, z), false);
                }
            }
            ++i1;
        }
    }

    public void func_205548_a(long seed) {
        if (this.seed != seed || this.blockState == null) {
            this.fillBlockStateArray(seed);
        }
        if (this.seed != seed || this.perlin1 == null || this.perlin2 == null) {
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
            this.perlin1 = new PerlinNoiseGenerator(sharedseedrandom, (List)ImmutableList.of((Object)0));
            this.perlin2 = new PerlinNoiseGenerator(sharedseedrandom, (List)ImmutableList.of((Object)0));
        }
        this.seed = seed;
    }

    protected void fillBlockStateArray(long seed) {
        this.blockState = new BlockState[64];
        Arrays.fill(this.blockState, PACKED_ICE2);
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
        this.perlin3 = new PerlinNoiseGenerator(sharedseedrandom, (List)ImmutableList.of((Object)0));
        for (int l1 = 0; l1 < 64; ++l1) {
            if ((l1 += sharedseedrandom.nextInt(5) + 1) >= 64) continue;
            this.blockState[l1] = BLUE_ICE;
        }
        int i2 = sharedseedrandom.nextInt(4) + 2;
        for (int i = 0; i < i2; ++i) {
            int j = sharedseedrandom.nextInt(3) + 1;
            int k = sharedseedrandom.nextInt(64);
            for (int l = 0; k + l < 64 && l < j; ++l) {
                this.blockState[k + l] = BLUE_ICE2;
            }
        }
        int j2 = sharedseedrandom.nextInt(4) + 2;
        for (int k2 = 0; k2 < j2; ++k2) {
            int i3 = sharedseedrandom.nextInt(3) + 2;
            int l3 = sharedseedrandom.nextInt(64);
            for (int i1 = 0; l3 + i1 < 64 && i1 < i3; ++i1) {
                this.blockState[l3 + i1] = PACKED_ICE3;
            }
        }
        int l2 = sharedseedrandom.nextInt(4) + 2;
        for (int j3 = 0; j3 < l2; ++j3) {
            int i4 = sharedseedrandom.nextInt(3) + 1;
            int k4 = sharedseedrandom.nextInt(64);
            for (int j1 = 0; k4 + j1 < 64 && j1 < i4; ++j1) {
                this.blockState[k4 + j1] = BLUE_ICE3;
            }
        }
        int k3 = sharedseedrandom.nextInt(3) + 3;
        int j4 = 0;
        for (int l4 = 0; l4 < k3; ++l4) {
            boolean i5 = true;
            j4 += sharedseedrandom.nextInt(16) + 4;
            for (int k1 = 0; j4 + k1 < 64 && k1 < 1; ++k1) {
                this.blockState[j4 + k1] = PACKED_ICE;
                if (j4 + k1 > 1 && sharedseedrandom.nextBoolean()) {
                    this.blockState[j4 + k1 - 1] = PACKED_ICE4;
                }
                if (j4 + k1 >= 63 || !sharedseedrandom.nextBoolean()) continue;
                this.blockState[j4 + k1 + 1] = PACKED_ICE4;
            }
        }
    }

    protected BlockState noiseBlockState(int x, int y, int z) {
        int i = (int)Math.round(this.perlin3.func_215464_a((double)x / 512.0, (double)z / 512.0, false) * 2.0);
        return this.blockState[(y + i + 64) % 64];
    }
}

