/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.surfacebuilder.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;

public class FillSurfaceBuilderConfig
implements ISurfaceBuilderConfig {
    public static final Codec<FillSurfaceBuilderConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.field_236796_a_.fieldOf("top_material").forGetter(config -> config.topMaterial), (App)BlockStateProvider.field_236796_a_.fieldOf("under_material").forGetter(config -> config.underMaterial), (App)BlockStateProvider.field_236796_a_.fieldOf("filler_material").forGetter(config -> config.fillMaterial), (App)Codec.INT.fieldOf("fill_down_to_y").orElse((Object)63).forGetter(config -> config.fillDownToY), (App)Codec.INT.fieldOf("fill_up_to_y").orElse((Object)0).forGetter(config -> config.fillDownToY), (App)BlockState.field_235877_b_.listOf().fieldOf("replace_list").forGetter(config -> config.replaceList.stream().map(Block::func_176223_P).collect(Collectors.toList()))).apply((Applicative)codecRecorder, FillSurfaceBuilderConfig::new));
    private final BlockStateProvider topMaterial;
    private final BlockStateProvider underMaterial;
    private final BlockStateProvider fillMaterial;
    private final int fillDownToY;
    private final int fillUpToY;
    private final Set<Block> replaceList;

    FillSurfaceBuilderConfig(BlockStateProvider topMaterial, BlockStateProvider underMaterial, BlockStateProvider fillMaterial, int fillDownToY, int fillUpToY, List<BlockState> whitelist) {
        this.topMaterial = topMaterial;
        this.underMaterial = underMaterial;
        this.fillMaterial = fillMaterial;
        this.fillDownToY = fillDownToY;
        this.fillUpToY = fillUpToY;
        this.replaceList = whitelist.stream().map(AbstractBlock.AbstractBlockState::func_177230_c).collect(Collectors.toSet());
    }

    public BlockState func_204108_a() {
        return Blocks.field_150350_a.func_176223_P();
    }

    public BlockState func_204109_b() {
        return Blocks.field_150350_a.func_176223_P();
    }

    public BlockStateProvider getFillMaterial() {
        return this.fillMaterial;
    }

    public BlockStateProvider getTopMaterial() {
        return this.topMaterial;
    }

    public BlockStateProvider getUnderMaterial() {
        return this.underMaterial;
    }

    public Set<Block> getReplaceList() {
        return this.replaceList;
    }

    public int getFillDownToY() {
        return this.fillDownToY;
    }

    public int getFillUpToY() {
        return this.fillUpToY;
    }

    public static class Builder {
        private BlockStateProvider topMaterial = new SimpleBlockStateProvider(Blocks.field_196658_i.func_176223_P());
        private BlockStateProvider underMaterial = new SimpleBlockStateProvider(Blocks.field_150346_d.func_176223_P());
        private BlockStateProvider fillMaterial = new SimpleBlockStateProvider(Blocks.field_150346_d.func_176223_P());
        private int fillUpToY = 63;
        private int fillDownToY = 0;
        private List<Block> replaceList = ImmutableList.of((Object)Blocks.field_150348_b);

        public Builder setTopBlock(Block block) {
            this.topMaterial = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setTopBlock(BlockState state) {
            this.topMaterial = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setTopBlock(BlockStateProvider provider) {
            this.topMaterial = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setUnderBlock(Block block) {
            this.underMaterial = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setUnderBlock(BlockState state) {
            this.underMaterial = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setUnderBlock(BlockStateProvider provider) {
            this.underMaterial = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setFillBlock(Block block) {
            this.fillMaterial = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setFillBlock(BlockState state) {
            this.fillMaterial = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setFillBlock(BlockStateProvider provider) {
            this.fillMaterial = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setFillDownToY(int fillDownToY) {
            this.fillDownToY = fillDownToY;
            return this;
        }

        public Builder setFillUpToY(int fillUpToY) {
            this.fillUpToY = fillUpToY;
            return this;
        }

        public Builder setReplaceList(ImmutableList<Block> replaceList) {
            this.replaceList = replaceList;
            return this;
        }

        public FillSurfaceBuilderConfig build() {
            return new FillSurfaceBuilderConfig(this.topMaterial, this.underMaterial, this.fillMaterial, this.fillDownToY, this.fillUpToY, this.replaceList.stream().map(Block::func_176223_P).collect(Collectors.toList()));
        }
    }
}

