/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.ConfigHolderObject;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.type.Pair;
import team.creative.creativecore.common.util.type.PairList;

public abstract class ConfigTypeConveration<T> {
    private static HashMap<Class, ConfigTypeConveration> types = new HashMap();
    private static PairList<Predicate<Class>, ConfigTypeConveration> specialTypes = new PairList();

    public static <T, U extends T> void registerType(Class<U> clazz, ConfigTypeConveration<T> type) {
        types.put(clazz, type);
    }

    public static void registerSpecialType(Predicate<Class> predicate, ConfigTypeConveration type) {
        specialTypes.add(predicate, type);
    }

    public static boolean has(Class typeClass) {
        if (types.containsKey(typeClass)) {
            return true;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return true;
        }
        return false;
    }

    public static ConfigTypeConveration get(Class typeClass) {
        ConfigTypeConveration converation = types.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).value;
        }
        throw new RuntimeException("Could not find converation for " + typeClass.getName());
    }

    public static Object read(Class typeClass, Object defaultValue, boolean loadDefault, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
        return ConfigTypeConveration.get(typeClass).readElement(defaultValue, loadDefault, element, side, key);
    }

    public static JsonElement write(Class typeClass, Object value, Object defaultValue, boolean saveDefault, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
        return ConfigTypeConveration.get(typeClass).writeElement(value, defaultValue, saveDefault, side, key);
    }

    public abstract T readElement(T var1, boolean var2, JsonElement var3, Dist var4, @Nullable ConfigKey.ConfigKeyField var5);

    public abstract JsonElement writeElement(T var1, T var2, boolean var3, Dist var4, @Nullable ConfigKey.ConfigKeyField var5);

    public boolean areEqual(T one, T two) {
        return one.equals(two);
    }

    public T set(ConfigKey.ConfigKeyField key, T value) {
        return value;
    }

    public static Object parseObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object) {
        if (ConfigTypeConveration.has(object.getClass())) {
            return object;
        }
        return new ConfigHolderObject(parent, synchronization, key, object);
    }

    static {
        SimpleConfigTypeConveration<Boolean> booleanType = new SimpleConfigTypeConveration<Boolean>(){

            @Override
            public Boolean readElement(Boolean defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return element.getAsBoolean();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Boolean value, Boolean defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }
        };
        ConfigTypeConveration.registerType(Boolean.TYPE, booleanType);
        ConfigTypeConveration.registerType(Boolean.class, booleanType);
        SimpleConfigTypeConveration<Number> numberType = new SimpleConfigTypeConveration<Number>(){

            @Override
            public Number readElement(Number defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    Class<?> clazz = defaultValue.getClass();
                    if (clazz == Float.class || clazz == Float.TYPE) {
                        return Float.valueOf(element.getAsFloat());
                    }
                    if (clazz == Double.class || clazz == Double.TYPE) {
                        return element.getAsDouble();
                    }
                    if (clazz == Byte.class || clazz == Byte.TYPE) {
                        return element.getAsByte();
                    }
                    if (clazz == Short.class || clazz == Short.TYPE) {
                        return element.getAsShort();
                    }
                    if (clazz == Integer.class || clazz == Integer.TYPE) {
                        return element.getAsInt();
                    }
                    if (clazz == Long.class || clazz == Long.TYPE) {
                        return element.getAsLong();
                    }
                    return element.getAsNumber();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Number value, Number defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            public boolean isDecimal(Class clazz) {
                return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
            }

            public Number parseDecimal(Class clazz, double decimal) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    return Float.valueOf((float)decimal);
                }
                return decimal;
            }

            public Number parseInt(Class clazz, int number) {
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    return (byte)number;
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    return (short)number;
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return (long)number;
                }
                return number;
            }

            @Override
            public Number set(ConfigKey.ConfigKeyField key, Number value) {
                Class clazz = key.getType();
                boolean decimal = this.isDecimal(clazz);
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field.getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null) {
                            return this.parseDecimal(clazz, MathHelper.func_151237_a((double)value.doubleValue(), (double)decRange.min(), (double)decRange.max()));
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field.getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null) {
                            return this.parseInt(clazz, MathHelper.func_76125_a((int)value.intValue(), (int)intRange.min(), (int)intRange.max()));
                        }
                    }
                }
                return value;
            }
        };
        ConfigTypeConveration.registerType(Byte.TYPE, numberType);
        ConfigTypeConveration.registerType(Byte.class, numberType);
        ConfigTypeConveration.registerType(Short.TYPE, numberType);
        ConfigTypeConveration.registerType(Short.class, numberType);
        ConfigTypeConveration.registerType(Integer.TYPE, numberType);
        ConfigTypeConveration.registerType(Integer.class, numberType);
        ConfigTypeConveration.registerType(Long.TYPE, numberType);
        ConfigTypeConveration.registerType(Long.class, numberType);
        ConfigTypeConveration.registerType(Float.TYPE, numberType);
        ConfigTypeConveration.registerType(Float.class, numberType);
        ConfigTypeConveration.registerType(Double.TYPE, numberType);
        ConfigTypeConveration.registerType(Double.class, numberType);
        ConfigTypeConveration.registerType(String.class, new SimpleConfigTypeConveration<String>(){

            @Override
            public String readElement(String defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return element.getAsString();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(String value, String defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }
        });
        ConfigTypeConveration.registerType(ConfigHolderObject.class, new ConfigTypeConveration<ConfigHolderObject>(){

            @Override
            public ConfigHolderObject readElement(ConfigHolderObject defaultValue, boolean loadDefault, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    defaultValue.load(loadDefault, (JsonObject)element, side);
                } else {
                    defaultValue.restoreDefault(side);
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ConfigHolderObject value, ConfigHolderObject defaultValue, boolean saveDefault, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                return value.save(saveDefault, side);
            }
        });
        ConfigTypeConveration.registerType(ConfigHolderDynamic.class, new ConfigTypeConveration<ConfigHolderDynamic>(){

            @Override
            public ConfigHolderDynamic readElement(ConfigHolderDynamic defaultValue, boolean loadDefault, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    defaultValue.load(loadDefault, (JsonObject)element, side);
                } else {
                    defaultValue.restoreDefault(side);
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ConfigHolderDynamic value, ConfigHolderDynamic defaultValue, boolean saveDefault, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                return value.save(saveDefault, side);
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> {
            if (x.isArray()) {
                if (ConfigTypeConveration.has(x.getComponentType())) {
                    return true;
                }
                throw new RuntimeException("Array with holders are not permitted");
            }
            return false;
        }, new ConfigTypeConveration(){

            public Object readElement(Object defaultValue, boolean loadDefault, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonArray()) {
                    JsonArray array = (JsonArray)element;
                    int size = Math.min(array.size(), Array.getLength(defaultValue));
                    Object object = Array.newInstance(defaultValue.getClass().getComponentType(), size);
                    for (int i = 0; i < size; ++i) {
                        Array.set(object, i, 6.read(defaultValue.getClass().getComponentType(), Array.get(defaultValue, i), loadDefault, array.get(i), side, null));
                    }
                    return object;
                }
                return defaultValue;
            }

            public JsonElement writeElement(Object value, Object defaultValue, boolean saveDefault, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                int length = Array.getLength(value);
                JsonArray array = new JsonArray();
                for (int i = 0; i < length; ++i) {
                    array.add(6.write(value.getClass().getComponentType(), Array.get(value, i), Array.get(defaultValue, i), saveDefault, side, null));
                }
                return array;
            }

            public boolean areEqual(Object one, Object two) {
                int lengthTwo;
                int lengthOne = Array.getLength(one);
                if (lengthOne != (lengthTwo = Array.getLength(two))) {
                    return false;
                }
                for (int i = 0; i < lengthOne; ++i) {
                    Object entryOne = Array.get(one, i);
                    Object entryTwo = Array.get(two, i);
                    if (entryOne.getClass().isArray()) {
                        if (!entryTwo.getClass().isArray()) {
                            return false;
                        }
                        if (!this.areEqual(entryOne, entryTwo)) {
                            return false;
                        }
                    }
                    if (entryOne.equals(entryTwo)) continue;
                    return false;
                }
                return true;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> x.isEnum(), new SimpleConfigTypeConveration<Enum>(){

            @Override
            public Enum readElement(Enum defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return Enum.valueOf(defaultValue.getDeclaringClass(), element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Enum value, Enum defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.name());
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> x == List.class || x == ArrayList.class, new ConfigTypeConveration<List>(){

            @Override
            public List readElement(List defaultValue, boolean loadDefault, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonArray()) {
                    JsonArray array = (JsonArray)element;
                    Class clazz = this.getListType(key);
                    ArrayList<Object> list = new ArrayList<Object>(array.size());
                    for (int i = 0; i < array.size(); ++i) {
                        list.add(8.read(clazz, null, loadDefault, array.get(i), side, null));
                    }
                    return list;
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(List value, List defaultValue, boolean saveDefault, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
                JsonArray array = new JsonArray();
                Class clazz = this.getListType(key);
                for (int i = 0; i < value.size(); ++i) {
                    array.add(8.write(clazz, value.get(i), null, saveDefault, side, null));
                }
                return array;
            }

            public Class getListType(ConfigKey.ConfigKeyField key) {
                ParameterizedType type = (ParameterizedType)key.field.getGenericType();
                return (Class)type.getActualTypeArguments()[0];
            }
        });
    }

    public static abstract class SimpleConfigTypeConveration<T>
    extends ConfigTypeConveration<T> {
        @Override
        public T readElement(T defaultValue, boolean loadDefault, JsonElement element, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
            return this.readElement(defaultValue, loadDefault, element);
        }

        public abstract T readElement(T var1, boolean var2, JsonElement var3);

        @Override
        public JsonElement writeElement(T value, T defaultValue, boolean saveDefault, Dist side, @Nullable ConfigKey.ConfigKeyField key) {
            return this.writeElement(value, defaultValue, saveDefault);
        }

        public abstract JsonElement writeElement(T var1, T var2, boolean var3);
    }
}

