/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.style.ControlStyle;
import team.creative.creativecore.common.gui.style.GuiStyle;

public abstract class GuiControl {
    private IGuiParent parent;
    public final String name;
    public boolean enabled = true;
    public int x;
    public int y;
    public int width;
    public int height;
    public boolean visible;

    public GuiControl(String name, int x, int y, int width, int height) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public GuiControl setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public void setParent(IGuiParent parent) {
        this.parent = parent;
    }

    public IGuiParent getParent() {
        return this.parent;
    }

    public GuiLayer getLayer() {
        if (this.parent instanceof GuiControl) {
            return ((GuiControl)((Object)this.parent)).getLayer();
        }
        throw new RuntimeException("Invalid layer control");
    }

    public GuiStyle getStyle() {
        if (this.parent instanceof GuiControl) {
            return ((GuiControl)((Object)this.parent)).getStyle();
        }
        throw new RuntimeException("Invalid layer control");
    }

    public abstract void init();

    public abstract void closed();

    public boolean is(String ... name) {
        for (int i = 0; i < name.length; ++i) {
            if (!this.name.equalsIgnoreCase(name[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isInterable() {
        return this.enabled && this.visible;
    }

    public boolean mousedClicked(int x, int y, int button) {
        return false;
    }

    public void mouseMoved(int x, int y, int button) {
    }

    public void mouseReleased(int x, int y, int button) {
    }

    public void mouseDragged(int x, int y, int button, long time) {
    }

    public boolean mouseScrolled(int x, int y, int scrolled) {
        return false;
    }

    public void looseFocus() {
    }

    public boolean keyPressed(char character, int key) {
        return false;
    }

    public abstract ControlStyle getControlStyle();

    public PlayerEntity getPlayer() {
        return this.parent.getPlayer();
    }

    public boolean isRemote() {
        return this.getPlayer().field_70170_p.field_72995_K;
    }

    public void moveBehind(GuiControl reference) {
        this.parent.moveBehind(this, reference);
    }

    public void moveInFront(GuiControl reference) {
        this.parent.moveInFront(this, reference);
    }

    public void moveTop() {
        this.parent.moveTop(this);
    }

    public void moveBottom() {
        this.parent.moveBottom(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String translate(String text, Object ... parameters) {
        return I18n.func_135052_a((String)text, (Object[])parameters);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String translateOrDefault(String text, String defaultText) {
        if (I18n.func_188566_a((String)text)) {
            return GuiControl.translate(text, new Object[0]);
        }
        return defaultText;
    }
}

