/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.common.entity.passive;

import com.minecraftabnormals.autumnity.core.other.AutumnityCriteriaTriggers;
import com.minecraftabnormals.autumnity.core.other.AutumnityTags;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBlocks;
import com.minecraftabnormals.autumnity.core.registry.AutumnityEntities;
import com.minecraftabnormals.autumnity.core.registry.AutumnityItems;
import com.minecraftabnormals.autumnity.core.registry.AutumnitySoundEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class SnailEntity
extends AnimalEntity {
    private static final UUID HIDING_ARMOR_BONUS_ID = UUID.fromString("73BF0604-4235-4D4C-8A74-6A633E526E24");
    private static final AttributeModifier HIDING_ARMOR_BONUS_MODIFIER = new AttributeModifier(HIDING_ARMOR_BONUS_ID, "Hiding armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Integer> EATING_TIME = EntityDataManager.func_187226_a(SnailEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HIDING = EntityDataManager.func_187226_a(SnailEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int hidingTime = 0;
    private int slimeAmount = 0;
    private float hideTicks;
    private float prevHideTicks;
    private int shakeTicks;
    private int prevShakeTicks;
    private boolean canBreed = true;
    private static final Predicate<LivingEntity> ENEMY_MATCHER = livingentity -> {
        if (livingentity == null) {
            return false;
        }
        livingentity.func_184582_a(EquipmentSlotType.CHEST);
        if (livingentity.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == AutumnityItems.SNAIL_SHELL_CHESTPLATE.get()) {
            return false;
        }
        if (livingentity instanceof PlayerEntity) {
            return !livingentity.func_225608_bj_() && !livingentity.func_175149_v() && !((PlayerEntity)livingentity).func_184812_l_();
        }
        return !(livingentity instanceof SnailEntity) && !(livingentity instanceof MooshroomEntity);
    };

    public SnailEntity(EntityType<? extends SnailEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new LookHelperController();
        this.field_70765_h = new MoveHelperController();
        this.func_184644_a(PathNodeType.DANGER_CACTUS, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_CACTUS, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new HideGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new StopHidingGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowFoodGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new EatMushroomsGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new EatMooshroomMushroomsGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(7, (Goal)new WatchGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 18.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)AutumnityItems.SNAIL_SPAWN_EGG.get());
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_SNAIL_DEATH.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)AutumnitySoundEvents.ENTITY_SNAIL_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)AutumnitySoundEvents.ENTITY_SNAIL_STEP.get(), 0.4f, 1.0f);
    }

    @Nullable
    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.prevHideTicks = this.hideTicks;
            this.hideTicks = this.getHiding() ? MathHelper.func_76131_a((float)(this.hideTicks + 1.0f), (float)0.0f, (float)3.0f) : MathHelper.func_76131_a((float)(this.hideTicks - 0.5f), (float)0.0f, (float)3.0f);
            this.prevShakeTicks = this.shakeTicks;
            this.shakeTicks = this.shakeTicks > 0 ? MathHelper.func_76125_a((int)(this.shakeTicks - 1), (int)0, (int)20) : MathHelper.func_76125_a((int)(this.shakeTicks + 1), (int)-20, (int)0);
        }
    }

    public void func_70636_d() {
        if (!this.canMove() || this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        }
        super.func_70636_d();
        if (this.isEating()) {
            this.eat();
            if (!this.field_70170_p.field_72995_K) {
                this.setEatingTime(this.getEatingTime() - 1);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                if (this.isFoodItem(itemstack)) {
                    if (!this.isEating()) {
                        this.setSlimeAmount(this.field_70146_Z.nextInt(3) + 5);
                        if (Ingredient.func_199805_a(AutumnityTags.SNAIL_GLOWING_FOODS).test(itemstack)) {
                            this.func_195064_c(new EffectInstance(Effects.field_188423_x, 200, 0));
                        }
                        if (Ingredient.func_199805_a(AutumnityTags.SNAIL_SPEEDING_FOODS).test(itemstack)) {
                            this.func_195064_c(new EffectInstance(Effects.field_76424_c, 320, 2));
                        }
                        Item item = itemstack.func_77973_b();
                        ItemStack itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                        if (!itemstack1.func_190926_b()) {
                            if (itemstack1.func_77973_b() != item) {
                                this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                                this.spitOutItem();
                            } else {
                                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                            }
                        }
                    }
                } else {
                    this.spitOutItem();
                }
            }
            if (this.getSlimeAmount() > 0 && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                int i = MathHelper.func_76128_c((double)this.func_226277_ct_());
                int j = MathHelper.func_76128_c((double)this.func_226278_cu_());
                int k = MathHelper.func_76128_c((double)this.func_226281_cx_());
                BlockState blockstate = ((Block)AutumnityBlocks.SNAIL_SLIME.get()).func_176223_P();
                for (int l = 0; l < 4; ++l) {
                    i = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                    j = MathHelper.func_76128_c((double)this.func_226278_cu_());
                    k = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
                    BlockPos blockpos = new BlockPos(i, j, k);
                    if (this.getSlimeAmount() <= 0 || !this.field_70170_p.func_175623_d(blockpos) || !blockstate.func_196955_c((IWorldReader)this.field_70170_p, blockpos)) continue;
                    this.field_70170_p.func_175656_a(blockpos, blockstate);
                    this.setSlimeAmount(this.getSlimeAmount() - 1);
                }
            }
            if (this.hidingTime > 0) {
                --this.hidingTime;
            }
        }
    }

    public void eat() {
        if ((this.getEatingTime() + 1) % 12 == 0 && !this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
            this.func_184185_a((SoundEvent)AutumnitySoundEvents.ENTITY_SNAIL_EAT.get(), 0.25f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1);
                vector3d = vector3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                vector3d = vector3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.2;
                Vector3d vector3d1 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.2, d0, 0.8 + ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.2);
                vector3d1 = vector3d1.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
                vector3d1 = vector3d1.func_72441_c(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_());
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184582_a(EquipmentSlotType.MAINHAND)), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
            }
        }
    }

    protected void func_175500_n() {
        super.func_175500_n();
        if (!this.func_70631_g_() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_199702_a((IItemProvider)AutumnityItems.SNAIL_SHELL_PIECE.get(), 1);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack;
        if (!this.getHiding() && !this.isEating() && !(itemstack = player.func_184586_b(hand)).func_190926_b() && this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
            if (this.isFoodItem(itemstack)) {
                if (!this.func_70631_g_() && this.getSlimeAmount() <= 0) {
                    if (!this.field_70170_p.field_72995_K) {
                        ItemStack itemstack1 = itemstack.func_77946_l();
                        itemstack1.func_190920_e(1);
                        this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                        this.setEatingTime(192);
                        AutumnityCriteriaTriggers.FEED_SNAIL.trigger((ServerPlayerEntity)player, itemstack1);
                    }
                    this.func_175505_a(player, itemstack);
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
                }
            } else if (this.isSnailBreedingItem(itemstack)) {
                boolean flag = false;
                if (!this.field_70170_p.field_72995_K && this.func_70874_b() == 0 && this.func_204701_dC()) {
                    this.func_146082_f(player);
                    flag = true;
                }
                if (this.func_70631_g_()) {
                    this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
                    flag = true;
                }
                if (flag) {
                    if (!this.field_70170_p.field_72995_K) {
                        ItemStack itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                        if (!player.field_71075_bZ.field_75098_d && !itemstack1.func_190926_b()) {
                            player.func_184611_a(hand, itemstack1);
                        }
                    }
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
                }
            }
        }
        this.canBreed = false;
        ActionResultType result = super.func_230254_b_(player, hand);
        this.canBreed = true;
        return result;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76364_f();
        if (this.getHiding() && entity instanceof AbstractArrowEntity) {
            return false;
        }
        if (source == DamageSource.field_76367_g) {
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (!this.field_70170_p.field_72995_K) {
            if (!this.func_175446_cd()) {
                this.hidingTime = 160 + this.field_70146_Z.nextInt(200);
                this.setHiding(true);
            }
            this.spitOutItem();
        } else {
            this.shakeTicks = this.field_70146_Z.nextInt(2) == 0 ? -10 : 10;
        }
        return flag;
    }

    private void spitOutItem() {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!itemstack.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c, itemstack);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.field_70170_p.func_217376_c((Entity)itementity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            this.setEatingTime(0);
        }
    }

    public int getEatingTime() {
        return (Integer)this.field_70180_af.func_187225_a(EATING_TIME);
    }

    public void setEatingTime(int eatingTimeIn) {
        this.field_70180_af.func_187227_b(EATING_TIME, (Object)eatingTimeIn);
    }

    public boolean isEating() {
        return this.getEatingTime() > 0;
    }

    public boolean getHiding() {
        return (Boolean)this.field_70180_af.func_187225_a(HIDING);
    }

    public void setHiding(boolean hiding) {
        if (hiding) {
            this.field_70180_af.func_187227_b(HIDING, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(HIDING, (Object)false);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(Attributes.field_233826_i_).func_111124_b(HIDING_ARMOR_BONUS_MODIFIER);
            if (hiding) {
                this.func_110148_a(Attributes.field_233826_i_).func_233767_b_(HIDING_ARMOR_BONUS_MODIFIER);
            }
        }
    }

    public boolean canMove() {
        return !this.getHiding() && !this.isEating();
    }

    private int getSlimeAmount() {
        return this.slimeAmount;
    }

    private void setSlimeAmount(int slimeAmountIn) {
        this.slimeAmount = slimeAmountIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHidingAnimationScale(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevHideTicks, (float)this.hideTicks) / 3.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHideTicks() {
        return this.hideTicks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakingAnimationScale(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevShakeTicks, (float)this.shakeTicks) / 10.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeTicks() {
        return this.shakeTicks;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EATING_TIME, (Object)0);
        this.field_70180_af.func_187214_a(HIDING, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("SlimeAmount", this.getSlimeAmount());
        compound.func_74757_a("Hiding", this.getHiding());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSlimeAmount(compound.func_74762_e("SlimeAmount"));
        this.setHiding(compound.func_74767_n("Hiding"));
    }

    private boolean isFoodItem(ItemStack stack) {
        return Ingredient.func_199805_a(AutumnityTags.SNAIL_FOODS).test(stack);
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.canBreed && this.isSnailBreedingItem(stack);
    }

    private boolean isSnailBreedingItem(ItemStack stack) {
        return Ingredient.func_199805_a(AutumnityTags.SNAIL_BREEDING_ITEMS).test(stack);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)AutumnityEntities.SNAIL.get()).func_200721_a((World)world);
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 0.6f;
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController() {
            super((MobEntity)SnailEntity.this);
        }

        public void func_75641_c() {
            if (SnailEntity.this.canMove()) {
                super.func_75641_c();
            }
        }
    }

    public class LookHelperController
    extends LookController {
        public LookHelperController() {
            super((MobEntity)SnailEntity.this);
        }

        public void func_75649_a() {
            if (!SnailEntity.this.getHiding()) {
                super.func_75649_a();
            }
        }
    }

    public class EatMooshroomMushroomsGoal
    extends Goal {
        private MooshroomEntity targetMooshroom;
        private int delayCounter;

        public boolean func_75250_a() {
            if (!SnailEntity.this.func_70631_g_() && SnailEntity.this.canMove() && SnailEntity.this.getSlimeAmount() <= 0) {
                List list = SnailEntity.this.field_70170_p.func_217357_a(MooshroomEntity.class, SnailEntity.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
                MooshroomEntity mooshroom = null;
                double d0 = Double.MAX_VALUE;
                for (MooshroomEntity mooshroom1 : list) {
                    double d1;
                    if (mooshroom1.func_70874_b() < 0 || (d1 = SnailEntity.this.func_70068_e((Entity)mooshroom1)) > d0) continue;
                    d0 = d1;
                    mooshroom = mooshroom1;
                }
                if (mooshroom == null) {
                    return false;
                }
                this.targetMooshroom = mooshroom;
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (!this.targetMooshroom.func_70089_S()) {
                return false;
            }
            if (!SnailEntity.this.canMove()) {
                return false;
            }
            if (SnailEntity.this.getSlimeAmount() > 0) {
                return false;
            }
            double d0 = this.targetMooshroom.func_70068_e((Entity)SnailEntity.this);
            return !(d0 > 256.0);
        }

        public void func_75249_e() {
            this.delayCounter = 0;
        }

        public void func_75251_c() {
            this.targetMooshroom = null;
        }

        public void func_75246_d() {
            double d0;
            if (--this.delayCounter <= 0) {
                this.delayCounter = 10;
                SnailEntity.this.func_70661_as().func_75497_a((Entity)this.targetMooshroom, 0.5);
            }
            if (this.targetMooshroom != null && this.targetMooshroom.func_70089_S() && (d0 = this.targetMooshroom.func_70068_e((Entity)SnailEntity.this)) < 2.0) {
                if (this.targetMooshroom.func_213444_dV() == MooshroomEntity.Type.BROWN) {
                    SnailEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_221692_bh, 1));
                } else {
                    SnailEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_221694_bi, 1));
                }
                SnailEntity.this.setEatingTime(192);
                this.targetMooshroom.func_70097_a(DamageSource.func_76358_a((LivingEntity)SnailEntity.this), 0.0f);
            }
        }
    }

    class EatMushroomsGoal
    extends Goal {
        private double mushroomX;
        private double mushroomY;
        private double mushroomZ;

        public EatMushroomsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (SnailEntity.this.func_70681_au().nextInt(20) != 0) {
                return false;
            }
            return !SnailEntity.this.func_70631_g_() && SnailEntity.this.canMove() && SnailEntity.this.getSlimeAmount() <= 0 && ForgeEventFactory.getMobGriefingEvent((World)SnailEntity.this.field_70170_p, (Entity)SnailEntity.this) && this.canMoveToMushroom();
        }

        protected boolean canMoveToMushroom() {
            Vector3d vec3d = this.findMushroom();
            if (vec3d == null) {
                return false;
            }
            this.mushroomX = vec3d.field_72450_a;
            this.mushroomY = vec3d.field_72448_b;
            this.mushroomZ = vec3d.field_72449_c;
            return true;
        }

        public boolean func_75253_b() {
            return !SnailEntity.this.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            SnailEntity.this.func_70661_as().func_75492_a(this.mushroomX, this.mushroomY, this.mushroomZ, 0.5);
        }

        @Nullable
        protected Vector3d findMushroom() {
            Random random = SnailEntity.this.func_70681_au();
            BlockPos blockpos = new BlockPos(SnailEntity.this.func_226277_ct_(), SnailEntity.this.func_174813_aQ().field_72338_b, SnailEntity.this.func_226281_cx_());
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
                if (!this.isBlockMushroom(blockpos1)) continue;
                return new Vector3d((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p());
            }
            return null;
        }

        public void func_75246_d() {
            BlockPos blockpos;
            if (!SnailEntity.this.func_70631_g_() && SnailEntity.this.canMove() && SnailEntity.this.getSlimeAmount() <= 0 && this.isBlockMushroom(blockpos = SnailEntity.this.func_233580_cy_()) && ForgeEventFactory.getMobGriefingEvent((World)SnailEntity.this.field_70170_p, (Entity)SnailEntity.this)) {
                SnailEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)SnailEntity.this.field_70170_p.func_180495_p(blockpos).func_177230_c().func_199767_j(), 1));
                SnailEntity.this.setEatingTime(192);
                SnailEntity.this.field_70170_p.func_175655_b(blockpos, false);
            }
        }

        private boolean isBlockMushroom(BlockPos pos) {
            return AutumnityTags.SNAIL_BLOCK_FOODS.func_230235_a_((Object)SnailEntity.this.field_70170_p.func_180495_p(pos).func_177230_c());
        }
    }

    class WatchGoal
    extends LookAtGoal {
        public WatchGoal() {
            super((MobEntity)SnailEntity.this, PlayerEntity.class, 6.0f);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !SnailEntity.this.getHiding();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !SnailEntity.this.getHiding();
        }
    }

    class FollowFoodGoal
    extends TemptGoal {
        public FollowFoodGoal() {
            super((CreatureEntity)SnailEntity.this, 0.5, false, null);
        }

        public boolean func_75250_a() {
            return SnailEntity.this.canMove() && super.func_75250_a();
        }

        protected boolean func_188508_a(ItemStack stack) {
            return Ingredient.func_199805_a(AutumnityTags.SNAIL_TEMPTATION_ITEMS).test(stack);
        }
    }

    public class StopHidingGoal
    extends Goal {
        public boolean func_75250_a() {
            return SnailEntity.this.func_70643_av() == null && SnailEntity.this.hidingTime <= 0;
        }

        public void func_75249_e() {
            SnailEntity.this.setHiding(false);
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    public class HideGoal
    extends Goal {
        public boolean func_75250_a() {
            if (!SnailEntity.this.getHiding() && !SnailEntity.this.isEating()) {
                for (LivingEntity livingentity : SnailEntity.this.field_70170_p.func_175647_a(LivingEntity.class, SnailEntity.this.func_174813_aQ().func_186662_g(0.3), ENEMY_MATCHER)) {
                    if (!livingentity.func_70089_S()) continue;
                    return true;
                }
            }
            return false;
        }

        public void func_75249_e() {
            SnailEntity.this.hidingTime = 100 + SnailEntity.this.field_70146_Z.nextInt(100);
            SnailEntity.this.setHiding(true);
        }

        public boolean func_75253_b() {
            return false;
        }
    }
}

