/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.minecraftabnormals.abnormals_core.client.model.SlabfishHatModel;
import com.minecraftabnormals.abnormals_core.client.renderer.SlabfishHatLayerRenderer;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.minecraftabnormals.abnormals_core.core.AbnormalsCore;
import com.minecraftabnormals.abnormals_core.core.config.ACConfig;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.github.ocelot.sonar.common.util.OnlineRequest;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="abnormals_core", value={Dist.CLIENT})
public final class RewardHandler {
    public static final Map<UUID, RewardData> REWARDS = new HashMap<UUID, RewardData>();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final String REWARDS_URL = "https://api.minecraftabnormals.com/rewards.json";
    private static final ResourceLocation CAPE_TEXTURE = new ResourceLocation("abnormals_core", "textures/abnormals_cape.png");
    private static final Set<UUID> RENDERED_CAPES = new HashSet<UUID>();
    private static RewardProperties rewardProperties;

    public static void clientSetup(FMLClientSetupEvent event) {
        OnlineRequest.request(REWARDS_URL, Util.func_215072_e()).thenAcceptAsync(stream -> {
            if (stream == null) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader((InputStream)stream);){
                JsonObject object = JSONUtils.func_212743_a((Reader)reader);
                for (Map.Entry entry : object.entrySet()) {
                    if (((String)entry.getKey()).equals("properties")) {
                        rewardProperties = (RewardProperties)GSON.fromJson((JsonElement)entry.getValue(), RewardProperties.class);
                        continue;
                    }
                    REWARDS.put(UUID.fromString((String)entry.getKey()), (RewardData)GSON.fromJson((JsonElement)entry.getValue(), RewardData.class));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse rewards.", (Throwable)e);
            }
        }, (Executor)Minecraft.func_71410_x());
        for (PlayerRenderer renderer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            renderer.func_177094_a((LayerRenderer)new SlabfishHatLayerRenderer((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)renderer, new SlabfishHatModel()));
        }
    }

    @Nullable
    public static RewardProperties getRewardProperties() {
        return rewardProperties;
    }

    @SubscribeEvent
    public static void onEvent(RenderPlayerEvent.Post event) {
        AbstractClientPlayerEntity clientPlayer;
        PlayerEntity player = event.getPlayer();
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
        if (!RENDERED_CAPES.contains(uuid) && REWARDS.containsKey(uuid) && REWARDS.get(uuid).getTier() >= 99 && (clientPlayer = (AbstractClientPlayerEntity)player).func_152122_n()) {
            Map playerTextures = clientPlayer.field_175157_a.field_187107_a;
            if (!playerTextures.containsKey(MinecraftProfileTexture.Type.CAPE)) {
                playerTextures.put(MinecraftProfileTexture.Type.CAPE, CAPE_TEXTURE);
                playerTextures.put(MinecraftProfileTexture.Type.ELYTRA, CAPE_TEXTURE);
            }
            RENDERED_CAPES.add(uuid);
        }
    }

    @SubscribeEvent
    public static void onEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
        NetworkUtil.updateSlabfish(SlabfishSetting.getConfig());
    }

    public static final class RewardData {
        private final String username;
        private final int tier;
        private final SlabfishData slabfish;

        public RewardData(String username, int tier, SlabfishData slabfish) {
            this.username = username;
            this.tier = tier;
            this.slabfish = slabfish;
        }

        public String getUsername() {
            return this.username;
        }

        public int getTier() {
            return this.tier;
        }

        public SlabfishData getSlabfish() {
            return this.slabfish;
        }

        public static final class SlabfishData {
            private final boolean translucent;
            @SerializedName(value="type")
            private final String typeUrl;
            @SerializedName(value="sweater")
            private final String sweaterUrl;
            @SerializedName(value="backpack")
            private final String backpackUrl;
            private String typeUrlCache;
            private String sweaterUrlCache;
            private String backpackUrlCache;

            public SlabfishData(boolean translucent, String typeUrl, String sweaterUrl, String backpackUrl) {
                this.translucent = translucent;
                this.typeUrl = typeUrl;
                this.sweaterUrl = sweaterUrl;
                this.backpackUrl = backpackUrl;
            }

            public boolean isTranslucent() {
                return this.translucent;
            }

            public String getTypeUrl() {
                return this.typeUrlCache == null ? (this.typeUrlCache = SlabfishData.resolveUrl(RewardProperties.SlabfishProperties::getTypeUrl, () -> this.typeUrl)) : this.typeUrlCache;
            }

            public String getSweaterUrl() {
                return this.sweaterUrlCache == null ? (this.sweaterUrlCache = SlabfishData.resolveUrl(RewardProperties.SlabfishProperties::getSweaterUrl, () -> this.sweaterUrl)) : this.sweaterUrlCache;
            }

            public String getBackpackUrl() {
                return this.backpackUrlCache == null ? (this.backpackUrlCache = SlabfishData.resolveUrl(RewardProperties.SlabfishProperties::getBackpackUrl, () -> this.backpackUrl)) : this.backpackUrlCache;
            }

            private static String resolveUrl(Function<RewardProperties.SlabfishProperties, String> baseUrl, Supplier<String> url) {
                String appliedUrl = baseUrl.apply(rewardProperties.getSlabfishProperties());
                if (url.get() == null) {
                    return null;
                }
                if (appliedUrl == null || url.get().startsWith("http")) {
                    return url.get();
                }
                return String.format(appliedUrl, url.get());
            }
        }
    }

    public static final class RewardProperties {
        private final SlabfishProperties slabfish;

        public RewardProperties(SlabfishProperties slabfish) {
            this.slabfish = slabfish;
        }

        public SlabfishProperties getSlabfishProperties() {
            return this.slabfish;
        }

        public static final class SlabfishProperties {
            private final String defaultTypeUrl;
            private final String typeUrl;
            private final String sweaterUrl;
            private final String backpackUrl;

            public SlabfishProperties(String defaultTypeUrl, String typeUrl, String sweaterUrl, String backpackUrl) {
                this.defaultTypeUrl = defaultTypeUrl;
                this.typeUrl = typeUrl;
                this.sweaterUrl = sweaterUrl;
                this.backpackUrl = backpackUrl;
            }

            public String getDefaultTypeUrl() {
                return this.defaultTypeUrl;
            }

            public String getTypeUrl() {
                return this.typeUrl;
            }

            public String getSweaterUrl() {
                return this.sweaterUrl;
            }

            public String getBackpackUrl() {
                return this.backpackUrl;
            }
        }
    }

    public static enum SlabfishSetting {
        ENABLED(() -> ACConfig.CLIENT.slabfishSettings.enabled),
        SWEATER(() -> ACConfig.CLIENT.slabfishSettings.sweaterEnabled),
        BACKPACK(() -> ACConfig.CLIENT.slabfishSettings.backpackEnabled),
        TYPE(() -> ACConfig.CLIENT.slabfishSettings.typeEnabled);

        private final Supplier<ForgeConfigSpec.ConfigValue<Boolean>> configValue;

        private SlabfishSetting(Supplier<ForgeConfigSpec.ConfigValue<Boolean>> configValue) {
            this.configValue = configValue;
        }

        public ForgeConfigSpec.ConfigValue<Boolean> getConfigValue() {
            return this.configValue.get();
        }

        public static byte getConfig() {
            int value = 0;
            for (SlabfishSetting setting : SlabfishSetting.values()) {
                if (!((Boolean)setting.getConfigValue().get()).booleanValue()) continue;
                value |= 1 << setting.ordinal();
            }
            return (byte)value;
        }

        public static boolean getSetting(IDataManager data, SlabfishSetting flag) {
            return (data.getValue(AbnormalsCore.SLABFISH_SETTINGS) >> flag.ordinal() & 1) > 0;
        }
    }
}

