/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.AdvancementModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers.CriteriaModifier;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.JSONUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class IndexedRequirementsModifier
extends AdvancementModifier<Config> {
    public IndexedRequirementsModifier() {
        super((element, conditionArrayParser) -> {
            JsonObject object = element.getAsJsonObject();
            AdvancementModifier.Mode mode = AdvancementModifier.Mode.deserialize(object);
            int index = JSONUtils.func_151203_m((JsonObject)object, (String)"index");
            Optional<Map<String, Criterion>> criterionMap = JSONUtils.func_151204_g((JsonObject)object, (String)"criteria") ? Optional.of(Criterion.func_232634_b_((JsonObject)object.getAsJsonObject("criteria"), (ConditionArrayParser)conditionArrayParser)) : Optional.empty();
            Optional<String[]> requirements = Optional.empty();
            if (criterionMap.isPresent()) {
                Map map = (Map)criterionMap.get();
                if (map.isEmpty()) {
                    throw new JsonParseException("Criteria cannot be empty! Don't include it instead");
                }
                if (JSONUtils.func_151204_g((JsonObject)object, (String)"requirements")) {
                    JsonArray requirementsArray = JSONUtils.func_151214_t((JsonObject)object, (String)"requirements");
                    Object[] strings = new String[requirementsArray.size()];
                    if (strings.length == 0) {
                        throw new JsonParseException("Requirements cannot be empty!");
                    }
                    for (int i = 0; i < strings.length; ++i) {
                        String string = requirementsArray.get(i).getAsString();
                        if (!map.containsKey(string)) {
                            throw new JsonParseException("Unknown required criterion '" + string + "'");
                        }
                        strings[i] = string;
                    }
                    for (String key : map.keySet()) {
                        if (ArrayUtils.contains((Object[])strings, (Object)key)) continue;
                        throw new JsonParseException("Criterion '" + key + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
                    }
                    requirements = Optional.of(strings);
                }
            }
            return new Config(mode, index, criterionMap, requirements);
        });
    }

    @Override
    public void modify(Advancement.Builder builder, Config config) {
        Map criteria = builder.func_200277_c();
        try {
            String[][] requirementsArray = (String[][])CriteriaModifier.REQUIREMENTS_FIELD.get(builder);
            int index = config.index;
            if (config.mode == AdvancementModifier.Mode.MODIFY) {
                config.requirements.ifPresent(strings -> {
                    requirementsArray[index] = (String[])ArrayUtils.addAll((Object[])requirementsArray[index], (Object[])strings);
                });
            } else {
                criteria.clear();
                requirementsArray[index] = config.requirements.orElse(new String[0]);
            }
            config.criterionMap.ifPresent(criteria::putAll);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    static class Config {
        private final AdvancementModifier.Mode mode;
        private final int index;
        private final Optional<Map<String, Criterion>> criterionMap;
        private final Optional<String[]> requirements;

        Config(AdvancementModifier.Mode mode, int index, Optional<Map<String, Criterion>> criterionMap, Optional<String[]> requirements) {
            this.index = index;
            this.mode = mode;
            this.criterionMap = criterionMap;
            this.requirements = requirements;
        }
    }
}

