/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.capability.chunkloading;

import com.minecraftabnormals.abnormals_core.common.capability.chunkloading.ChunkLoader;
import com.minecraftabnormals.abnormals_core.common.capability.chunkloading.IChunkLoader;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ChunkLoaderCapability
implements ICapabilitySerializable<INBT> {
    @CapabilityInject(value=IChunkLoader.class)
    public static Capability<IChunkLoader> CHUNK_LOAD_CAP = null;
    private final LazyOptional<IChunkLoader> instance;

    public ChunkLoaderCapability(LazyOptional<IChunkLoader> instance) {
        this.instance = instance;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return CHUNK_LOAD_CAP.orEmpty(cap, this.instance);
    }

    public INBT serializeNBT() {
        return CHUNK_LOAD_CAP.writeNBT(this.instance.orElse(null), null);
    }

    public void deserializeNBT(INBT nbt) {
        CHUNK_LOAD_CAP.readNBT(this.instance.orElse(null), null, nbt);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IChunkLoader.class, (Capability.IStorage)new Capability.IStorage<IChunkLoader>(){

            public INBT writeNBT(Capability<IChunkLoader> capability, IChunkLoader instance, Direction side) {
                ChunkLoader loader = (ChunkLoader)instance;
                return new LongArrayNBT(loader.loadedPositions);
            }

            public void readNBT(Capability<IChunkLoader> capability, IChunkLoader instance, Direction side, INBT nbt) {
                ChunkLoader loader = (ChunkLoader)instance;
                loader.loadedPositions.clear();
                long[] lArray = ((LongArrayNBT)nbt).func_197652_h();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long pos = lArray[i];
                    loader.addPos(BlockPos.func_218283_e((long)pos));
                }
            }
        }, () -> new ChunkLoader(null));
    }
}

