/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.network;

import com.minecraftabnormals.abnormals_core.client.ClientInfo;
import com.minecraftabnormals.abnormals_core.common.tileentity.AbnormalsSignTileEntity;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.DyeColor;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageS2CUpdateSign {
    private BlockPos signPos;
    private String topLine;
    private String secondLine;
    private String thirdLine;
    private String bottomLine;
    private int color;

    public MessageS2CUpdateSign(BlockPos signPos, String topLine, String secondLine, String thirdLine, String bottomLine, int color) {
        this.signPos = signPos;
        this.topLine = topLine;
        this.secondLine = secondLine;
        this.thirdLine = thirdLine;
        this.bottomLine = bottomLine;
        this.color = color;
    }

    public void serialize(PacketBuffer buf) {
        buf.func_179255_a(this.signPos);
        buf.func_180714_a(this.topLine);
        buf.func_180714_a(this.secondLine);
        buf.func_180714_a(this.thirdLine);
        buf.func_180714_a(this.bottomLine);
        buf.writeInt(this.color);
    }

    public static MessageS2CUpdateSign deserialize(PacketBuffer buf) {
        return new MessageS2CUpdateSign(buf.func_179259_c(), buf.func_218666_n(), buf.func_218666_n(), buf.func_218666_n(), buf.func_218666_n(), buf.readInt());
    }

    public static void handle(MessageS2CUpdateSign message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                BlockPos blockpos;
                ClientWorld world = (ClientWorld)ClientInfo.getClientPlayerWorld();
                if (world.func_175667_e(blockpos = message.signPos)) {
                    TileEntity tileentity = world.func_175625_s(blockpos);
                    if (!(tileentity instanceof AbnormalsSignTileEntity)) {
                        return;
                    }
                    AbnormalsSignTileEntity signtileentity = (AbnormalsSignTileEntity)tileentity;
                    signtileentity.setText(0, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)message.topLine)));
                    signtileentity.setText(1, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)message.secondLine)));
                    signtileentity.setText(2, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)message.thirdLine)));
                    signtileentity.setText(3, (ITextComponent)new StringTextComponent(TextFormatting.func_110646_a((String)message.bottomLine)));
                    signtileentity.setTextColor(DyeColor.func_196056_a((int)message.color));
                }
            });
            context.setPacketHandled(true);
        }
    }
}

