/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.world.modification;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationContext;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public final class BiomeFeatureModifier
extends BiomeModifier {
    public static final Set<GenerationStage.Decoration> ALL_STAGES = Sets.newHashSet((Object[])GenerationStage.Decoration.values());

    private BiomeFeatureModifier(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Consumer<BiomeModificationContext> modifier) {
        super(shouldModify, modifier);
    }

    public static BiomeFeatureModifier createFeatureAdder(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, GenerationStage.Decoration stage, Supplier<ConfiguredFeature<?, ?>> feature) {
        return new BiomeFeatureModifier(shouldModify, context -> context.event.getGeneration().getFeatures(stage).add(feature));
    }

    public static BiomeFeatureModifier createMultiFeatureAdder(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, GenerationStage.Decoration stage, Set<Supplier<ConfiguredFeature<?, ?>>> features) {
        return new BiomeFeatureModifier(shouldModify, context -> context.event.getGeneration().getFeatures(stage).addAll(features));
    }

    public static BiomeFeatureModifier createMultiFeatureAdder(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Set<GenerationStage.Decoration> stages, Set<Supplier<ConfiguredFeature<?, ?>>> features) {
        return new BiomeFeatureModifier(shouldModify, context -> {
            BiomeGenerationSettingsBuilder builder = context.event.getGeneration();
            for (GenerationStage.Decoration stage : stages) {
                builder.getFeatures(stage).addAll(features);
            }
        });
    }

    public static BiomeFeatureModifier createFeatureRemover(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Set<GenerationStage.Decoration> stages, Supplier<Feature<?>> featureSupplier) {
        return new BiomeFeatureModifier(shouldModify, context -> {
            BiomeGenerationSettingsBuilder settingsBuilder = context.event.getGeneration();
            for (GenerationStage.Decoration stage : stages) {
                Feature toRemove = (Feature)featureSupplier.get();
                settingsBuilder.getFeatures(stage).removeIf(configuredFeatureSupplier -> {
                    IFeatureConfig config = ((ConfiguredFeature)configuredFeatureSupplier.get()).field_222738_b;
                    return config instanceof DecoratedFeatureConfig && toRemove == ((ConfiguredFeature)((DecoratedFeatureConfig)config).field_214689_a.get()).field_222737_a;
                });
            }
        });
    }

    public static BiomeFeatureModifier createMultiFeatureRemover(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Set<GenerationStage.Decoration> stages, Set<Supplier<Feature<?>>> featureSuppliers) {
        return new BiomeFeatureModifier(shouldModify, context -> {
            HashSet features = Sets.newHashSet();
            featureSuppliers.forEach(featureSupplier -> features.add(featureSupplier.get()));
            BiomeGenerationSettingsBuilder settingsBuilder = context.event.getGeneration();
            for (GenerationStage.Decoration stage : stages) {
                settingsBuilder.getFeatures(stage).removeIf(configuredFeatureSupplier -> {
                    IFeatureConfig config = ((ConfiguredFeature)configuredFeatureSupplier.get()).field_222738_b;
                    return config instanceof DecoratedFeatureConfig && features.contains(((ConfiguredFeature)((DecoratedFeatureConfig)config).field_214689_a.get()).field_222737_a);
                });
            }
        });
    }

    public static BiomeFeatureModifier createFeatureReplacer(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Set<GenerationStage.Decoration> stages, Supplier<Feature<?>> toReplace, Supplier<ConfiguredFeature<?, ?>> replacer) {
        return new BiomeFeatureModifier(shouldModify, context -> {
            BiomeGenerationSettingsBuilder settingsBuilder = context.event.getGeneration();
            Feature replace = (Feature)toReplace.get();
            for (GenerationStage.Decoration stage : stages) {
                HashSet toRemove = Sets.newHashSet();
                List features = settingsBuilder.getFeatures(stage);
                for (Supplier configuredFeatureSupplier : features) {
                    IFeatureConfig config = ((ConfiguredFeature)configuredFeatureSupplier.get()).field_222738_b;
                    if (!(config instanceof DecoratedFeatureConfig) || ((ConfiguredFeature)((DecoratedFeatureConfig)config).field_214689_a.get()).field_222737_a != replace) continue;
                    toRemove.add(configuredFeatureSupplier);
                }
                toRemove.forEach(arg_0 -> BiomeFeatureModifier.lambda$null$8(features, (Supplier)replacer, arg_0));
            }
        });
    }

    public static BiomeFeatureModifier createMultiFeatureReplacer(BiPredicate<RegistryKey<Biome>, Biome> shouldModify, Set<GenerationStage.Decoration> stages, Set<Supplier<Feature<?>>> toReplace, Supplier<ConfiguredFeature<?, ?>> replacer) {
        return new BiomeFeatureModifier(shouldModify, context -> {
            HashSet features = Sets.newHashSet();
            toReplace.forEach(featureSupplier -> features.add(featureSupplier.get()));
            BiomeGenerationSettingsBuilder settingsBuilder = context.event.getGeneration();
            for (GenerationStage.Decoration stage : stages) {
                HashSet toRemove = Sets.newHashSet();
                List configuredFeatures = settingsBuilder.getFeatures(stage);
                for (Supplier configuredFeatureSupplier : configuredFeatures) {
                    IFeatureConfig config = ((ConfiguredFeature)configuredFeatureSupplier.get()).field_222738_b;
                    if (!(config instanceof DecoratedFeatureConfig) || !features.contains(((ConfiguredFeature)((DecoratedFeatureConfig)config).field_214689_a.get()).field_222737_a)) continue;
                    toRemove.add(configuredFeatureSupplier);
                }
                toRemove.forEach(arg_0 -> BiomeFeatureModifier.lambda$null$11(configuredFeatures, (Supplier)replacer, arg_0));
            }
        });
    }

    private static /* synthetic */ void lambda$null$11(List configuredFeatures, Supplier replacer, Supplier configuredFeature) {
        configuredFeatures.remove(configuredFeature);
        configuredFeatures.add(replacer);
    }

    private static /* synthetic */ void lambda$null$8(List features, Supplier replacer, Supplier configuredFeature) {
        features.remove(configuredFeature);
        features.add(replacer);
    }
}

