/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.client.RewardHandler;
import com.minecraftabnormals.abnormals_core.client.renderer.AbnormalsBoatRenderer;
import com.minecraftabnormals.abnormals_core.client.tile.AbnormalsChestTileEntityRenderer;
import com.minecraftabnormals.abnormals_core.client.tile.AbnormalsSignTileEntityRenderer;
import com.minecraftabnormals.abnormals_core.common.blocks.AbnormalsBeehiveBlock;
import com.minecraftabnormals.abnormals_core.common.capability.chunkloading.ChunkLoaderCapability;
import com.minecraftabnormals.abnormals_core.common.capability.chunkloading.ChunkLoaderEvents;
import com.minecraftabnormals.abnormals_core.common.network.MessageC2SEditSign;
import com.minecraftabnormals.abnormals_core.common.network.MessageC2SUpdateSlabfishHat;
import com.minecraftabnormals.abnormals_core.common.network.MessageS2CServerRedirect;
import com.minecraftabnormals.abnormals_core.common.network.MessageS2CUpdateSign;
import com.minecraftabnormals.abnormals_core.common.network.MessageSOpenSignEditor;
import com.minecraftabnormals.abnormals_core.common.network.entity.MessageS2CEndimation;
import com.minecraftabnormals.abnormals_core.common.network.entity.MessageS2CTeleportEntity;
import com.minecraftabnormals.abnormals_core.common.network.entity.MessageS2CUpdateEntityData;
import com.minecraftabnormals.abnormals_core.common.network.particle.MessageS2CSpawnParticle;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.DataProcessors;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.TrackedData;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.TrackedDataManager;
import com.minecraftabnormals.abnormals_core.core.api.banner.BannerManager;
import com.minecraftabnormals.abnormals_core.core.api.conditions.ACAndRecipeCondition;
import com.minecraftabnormals.abnormals_core.core.api.conditions.QuarkFlagRecipeCondition;
import com.minecraftabnormals.abnormals_core.core.config.ACConfig;
import com.minecraftabnormals.abnormals_core.core.endimator.EndimationDataManager;
import com.minecraftabnormals.abnormals_core.core.registry.ACEntities;
import com.minecraftabnormals.abnormals_core.core.registry.ACTileEntities;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import com.minecraftabnormals.abnormals_core.core.util.registry.AbstractSubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.TileEntitySubRegistryHelper;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="abnormals_core")
@Mod.EventBusSubscriber(modid="abnormals_core", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class AbnormalsCore {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "abnormals_core";
    public static final String NETWORK_PROTOCOL = "AC1";
    public static final EndimationDataManager ENDIMATION_DATA_MANAGER = new EndimationDataManager();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("abnormals_core");
    public static final TrackedData<Byte> SLABFISH_SETTINGS = TrackedData.Builder.create(DataProcessors.BYTE, () -> (byte)8).enablePersistence().build();
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("abnormals_core", "net")).networkProtocolVersion(() -> "AC1").clientAcceptedVersions("AC1"::equals).serverAcceptedVersions("AC1"::equals).simpleChannel();

    public AbnormalsCore() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ChunkLoaderEvents());
        this.setupMessages();
        CraftingHelper.register((IConditionSerializer)new QuarkFlagRecipeCondition.Serializer());
        CraftingHelper.register((IConditionSerializer)new ACAndRecipeCondition.Serializer());
        BannerManager.RECIPE_SERIALIZERS.register(modEventBus);
        ((AbstractSubRegistryHelper)REGISTRY_HELPER.getEntitySubHelper()).register(modEventBus);
        ((AbstractSubRegistryHelper)REGISTRY_HELPER.getTileEntitySubHelper()).register(modEventBus);
        modEventBus.addListener(event -> {
            ModConfig config = event.getConfig();
            if (config.getSpec() == ACConfig.COMMON_SPEC) {
                ACConfig.ValuesHolder.updateCommonValuesFromConfig(config);
            }
        });
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(EventPriority.NORMAL, false, ColorHandlerEvent.Block.class, event -> {
                IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
                if (resourceManager instanceof IReloadableResourceManager) {
                    ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)ENDIMATION_DATA_MANAGER);
                }
            });
            modEventBus.addListener(EventPriority.NORMAL, false, ModConfig.Reloading.class, event -> {
                if (event.getConfig().getModId().equals(MODID)) {
                    NetworkUtil.updateSlabfish(RewardHandler.SlabfishSetting.getConfig());
                }
            });
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(RewardHandler::clientSetup);
        });
        modEventBus.addListener(EventPriority.LOWEST, this::commonSetup);
        context.registerConfig(ModConfig.Type.COMMON, ACConfig.COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, ACConfig.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(this::replaceBeehivePOI);
        ChunkLoaderCapability.register();
        TrackedDataManager.INSTANCE.registerData(new ResourceLocation(MODID, "slabfish_head"), SLABFISH_SETTINGS);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ACEntities.BOAT.get()), AbnormalsBoatRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ACTileEntities.CHEST.get()), AbnormalsChestTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ACTileEntities.TRAPPED_CHEST.get()), AbnormalsChestTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ACTileEntities.SIGN.get()), AbnormalsSignTileEntityRenderer::new);
    }

    private void setupMessages() {
        int id = -1;
        CHANNEL.registerMessage(id++, MessageS2CEndimation.class, MessageS2CEndimation::serialize, MessageS2CEndimation::deserialize, MessageS2CEndimation::handle);
        CHANNEL.registerMessage(id++, MessageSOpenSignEditor.class, MessageSOpenSignEditor::serialize, MessageSOpenSignEditor::deserialize, MessageSOpenSignEditor::handle);
        CHANNEL.registerMessage(id++, MessageC2SEditSign.class, MessageC2SEditSign::serialize, MessageC2SEditSign::deserialize, MessageC2SEditSign::handle);
        CHANNEL.registerMessage(id++, MessageS2CUpdateSign.class, MessageS2CUpdateSign::serialize, MessageS2CUpdateSign::deserialize, MessageS2CUpdateSign::handle);
        CHANNEL.registerMessage(id++, MessageS2CTeleportEntity.class, MessageS2CTeleportEntity::serialize, MessageS2CTeleportEntity::deserialize, MessageS2CTeleportEntity::handle);
        CHANNEL.registerMessage(id++, MessageS2CSpawnParticle.class, MessageS2CSpawnParticle::serialize, MessageS2CSpawnParticle::deserialize, MessageS2CSpawnParticle::handle);
        CHANNEL.registerMessage(id++, MessageS2CServerRedirect.class, MessageS2CServerRedirect::serialize, MessageS2CServerRedirect::deserialize, MessageS2CServerRedirect::handle);
        CHANNEL.registerMessage(id++, MessageS2CUpdateEntityData.class, MessageS2CUpdateEntityData::serialize, MessageS2CUpdateEntityData::deserialize, MessageS2CUpdateEntityData::handle);
        CHANNEL.registerMessage(id, MessageC2SUpdateSlabfishHat.class, MessageC2SUpdateSlabfishHat::serialize, MessageC2SUpdateSlabfishHat::deserialize, MessageC2SUpdateSlabfishHat::handle);
    }

    private void replaceBeehivePOI() {
        PointOfInterestType.field_226356_s_.field_221075_w = Sets.newHashSet((Iterable)PointOfInterestType.field_226356_s_.field_221075_w);
        Map statePointOfInterestMap = PointOfInterestType.field_221073_u;
        for (Block block : TileEntitySubRegistryHelper.collectBlocks(AbnormalsBeehiveBlock.class)) {
            block.func_176194_O().func_177619_a().forEach(state -> {
                statePointOfInterestMap.put(state, PointOfInterestType.field_226356_s_);
                PointOfInterestType.field_226356_s_.field_221075_w.add(state);
            });
        }
    }
}

