/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.endimator;

import com.minecraftabnormals.abnormals_core.core.endimator.EndimationDataManager;
import com.minecraftabnormals.abnormals_core.core.endimator.entity.EndimatorEntityModel;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class Endimation {
    @Nullable
    private final ResourceLocation instructionsLocation;
    private int tickDuration;

    public Endimation(ResourceLocation instructionsLocation, int tickDuration) {
        this.instructionsLocation = instructionsLocation;
        this.tickDuration = tickDuration;
    }

    public Endimation(int tickDuration) {
        this(null, tickDuration);
    }

    public Endimation() {
        this(0);
    }

    public <E extends Entity> void processInstructions(EndimatorEntityModel<E> model) {
        Objects.requireNonNull(this.instructionsLocation, "Instructions are null, this should not be the case!");
        EndimationDataManager.ENDIMATIONS.get(this.instructionsLocation).processInstructions(model);
    }

    @Nullable
    public ResourceLocation getInstructionsLocation() {
        return this.instructionsLocation;
    }

    public int getAnimationTickDuration() {
        return this.tickDuration;
    }
}

