/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.util;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;

public final class ScrollHandler
implements INBTSerializable<CompoundNBT> {
    public static final float DEFAULT_SCROLL_SPEED = 5.0f;
    public static final float DEFAULT_TRANSITION_SPEED = 0.5f;
    public static final float DEFAULT_MIN_SNAP = 0.1f;
    private final Runnable markDirty;
    private int height;
    private int visibleHeight;
    private float scroll;
    private float lastScroll;
    private float nextScroll;
    private float scrollSpeed;
    private float transitionSpeed;
    private float minSnap;

    public ScrollHandler(@Nullable Runnable markDirty, int height, int visibleHeight) {
        this.markDirty = markDirty;
        this.height = height;
        this.visibleHeight = visibleHeight;
        this.scroll = 0.0f;
        this.scrollSpeed = 5.0f;
        this.transitionSpeed = 0.5f;
        this.minSnap = 0.1f;
    }

    public void update() {
        this.lastScroll = this.scroll;
        if (this.getMaxScroll() > 0.0f) {
            float delta = this.nextScroll - this.scroll;
            this.scroll = Math.abs(delta) < this.minSnap ? this.nextScroll : (this.scroll += delta * this.transitionSpeed);
            if (this.scroll < 0.0f) {
                this.scroll = 0.0f;
                this.nextScroll = 0.0f;
                if (this.markDirty != null) {
                    this.markDirty.run();
                }
            }
            if (this.scroll >= this.getMaxScroll()) {
                this.scroll = this.getMaxScroll();
                this.nextScroll = this.getMaxScroll();
                if (this.markDirty != null) {
                    this.markDirty.run();
                }
            }
        }
    }

    public boolean mouseScrolled(double maxScroll, double amount) {
        if (this.getMaxScroll() > 0.0f) {
            float scrollAmount = (float)Math.min(Math.abs(amount), maxScroll) * this.getScrollSpeed();
            float finalScroll = (float)(amount < 0.0 ? -1 : 1) * scrollAmount;
            float scroll = MathHelper.func_76131_a((float)(this.getScroll() - finalScroll), (float)0.0f, (float)this.getMaxScroll());
            if (this.getScroll() != scroll) {
                this.scroll(finalScroll);
                return true;
            }
        }
        return false;
    }

    public ScrollHandler scroll(float scrollAmount) {
        this.nextScroll -= scrollAmount;
        if (this.markDirty != null) {
            this.markDirty.run();
        }
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public int getVisibleHeight() {
        return this.visibleHeight;
    }

    public float getScroll() {
        return this.scroll;
    }

    public float getMaxScroll() {
        return Math.max(0, this.height - this.visibleHeight);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getInterpolatedScroll(float partialTicks) {
        return this.lastScroll + (this.scroll - this.lastScroll) * partialTicks;
    }

    public float getScrollSpeed() {
        return this.scrollSpeed;
    }

    public float getLastScroll() {
        return this.lastScroll;
    }

    public float getNextScroll() {
        return this.nextScroll;
    }

    public ScrollHandler setHeight(int height) {
        this.height = height;
        this.setScroll(this.scroll);
        return this;
    }

    public ScrollHandler setVisibleHeight(int visibleHeight) {
        this.visibleHeight = visibleHeight;
        this.setScroll(this.scroll);
        return this;
    }

    public ScrollHandler setScroll(float scroll) {
        this.nextScroll = this.scroll = MathHelper.func_76131_a((float)scroll, (float)0.0f, (float)(this.height - this.visibleHeight));
        this.lastScroll = this.scroll;
        if (this.markDirty != null) {
            this.markDirty.run();
        }
        return this;
    }

    public ScrollHandler setTransitionSpeed(float transitionSpeed) {
        this.transitionSpeed = transitionSpeed;
        if (this.markDirty != null) {
            this.markDirty.run();
        }
        return this;
    }

    public ScrollHandler setMinSnap(float minSnap) {
        this.minSnap = minSnap;
        if (this.markDirty != null) {
            this.markDirty.run();
        }
        return this;
    }

    public ScrollHandler setScrollSpeed(float scrollSpeed) {
        this.scrollSpeed = Math.max(scrollSpeed, 0.0f);
        if (this.markDirty != null) {
            this.markDirty.run();
        }
        return this;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74776_a("scroll", this.scroll);
        nbt.func_74776_a("nextScroll", this.nextScroll);
        nbt.func_74776_a("scrollSpeed", this.scrollSpeed);
        nbt.func_74776_a("transitionSpeed", this.transitionSpeed);
        nbt.func_74776_a("minSnap", this.minSnap);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.scroll = nbt.func_74760_g("scroll");
        this.nextScroll = nbt.func_74760_g("nextScroll");
        this.scrollSpeed = nbt.func_74760_g("scrollSpeed");
        this.transitionSpeed = nbt.func_74760_g("transitionSpeed");
        this.minSnap = nbt.func_74760_g("minSnap");
    }
}

