/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.LazyValue;
import net.minecraft.util.NonNullList;

public abstract class SortedItemGroup
extends ItemGroup {
    private final List<Supplier<? extends Item>> orderedItems = new ArrayList<Supplier<? extends Item>>();
    private final LazyValue<Map<Item, Integer>> indexedItems = new LazyValue(this::indexItems);

    public SortedItemGroup(String label) {
        super(label);
    }

    public SortedItemGroup(int index, String label) {
        super(index, label);
    }

    private Map<Item, Integer> indexItems() {
        HashMap<Item, Integer> indexMap = new HashMap<Item, Integer>();
        for (int i = 0; i < this.orderedItems.size(); ++i) {
            indexMap.put(this.orderedItems.get(i).get(), i);
        }
        return indexMap;
    }

    private int getIndex(Item item) {
        Map indexes = (Map)this.indexedItems.func_179281_c();
        return indexes.containsKey(item) ? ((Integer)indexes.get(item)).intValue() : indexes.size();
    }

    public void func_78018_a(NonNullList<ItemStack> items) {
        super.func_78018_a(items);
        items.sort((stack1, stack2) -> {
            int index1 = this.getIndex(stack1.func_77973_b());
            int index2 = this.getIndex(stack2.func_77973_b());
            if (((Map)this.indexedItems.func_179281_c()).containsKey(stack1.func_77973_b()) || ((Map)this.indexedItems.func_179281_c()).containsKey(stack2.func_77973_b())) {
                return Integer.compare(index1, index2);
            }
            if (stack1.func_77973_b().getRegistryName() == null || stack2.func_77973_b().getRegistryName() == null) {
                return 1;
            }
            return 1 + stack1.func_77973_b().getRegistryName().compareTo(stack2.func_77973_b().getRegistryName());
        });
    }

    public List<Supplier<? extends Item>> getOrderedItems() {
        return this.orderedItems;
    }
}

