/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.valuecontainer;

import io.github.ocelot.sonar.common.valuecontainer.NumberValueContainerEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class ByteValueContainerEntry
extends NumberValueContainerEntry<Byte> {
    private final ITextComponent displayName;
    private boolean bounds;

    public ByteValueContainerEntry(ITextComponent displayName, String name, byte value) {
        this(displayName, name, value, -128, 127);
        this.bounds = false;
    }

    public ByteValueContainerEntry(ITextComponent displayName, String name, byte value, byte minValue, byte maxValue) {
        super(name, value, minValue, maxValue);
        this.displayName = displayName;
        this.bounds = true;
    }

    @Override
    protected Byte getValue(Number number) {
        return number.byteValue();
    }

    @Override
    protected Byte clamp(Byte value, Byte minValue, Byte maxValue) {
        if (value < minValue) {
            value = minValue;
        }
        if (value > maxValue) {
            value = maxValue;
        }
        return value;
    }

    @Override
    protected boolean hasBounds() {
        return this.bounds;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74774_a(this.getName(), ((Byte)this.value).byteValue());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 1) ? Byte.valueOf(nbt.func_74771_c(this.getName())) : (Byte)this.getPreviousValue();
    }

    @Override
    public boolean isDecimal() {
        return false;
    }
}

