/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.valuecontainer;

import io.github.ocelot.sonar.common.valuecontainer.NumberValueContainerEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class DoubleValueContainerEntry
extends NumberValueContainerEntry<Double> {
    private final ITextComponent displayName;
    private boolean bounds;

    public DoubleValueContainerEntry(ITextComponent displayName, String name, double value) {
        this(displayName, name, value, Double.MIN_VALUE, Double.MAX_VALUE);
        this.bounds = false;
    }

    public DoubleValueContainerEntry(ITextComponent displayName, String name, double value, double minValue, double maxValue) {
        super(name, value, minValue, maxValue);
        this.displayName = displayName;
        this.bounds = true;
    }

    @Override
    protected Double getValue(Number number) {
        return number.doubleValue();
    }

    @Override
    protected Double clamp(Double value, Double minValue, Double maxValue) {
        if (value < minValue) {
            value = minValue;
        }
        if (value > maxValue) {
            value = maxValue;
        }
        return value;
    }

    @Override
    protected boolean hasBounds() {
        return this.bounds;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74780_a(this.getName(), ((Double)this.value).doubleValue());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 6) ? Double.valueOf(nbt.func_74769_h(this.getName())) : (Double)this.getPreviousValue();
    }

    @Override
    public boolean isDecimal() {
        return true;
    }
}

