/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.valuecontainer;

import io.github.ocelot.sonar.common.valuecontainer.NumberValueContainerEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class ShortValueContainerEntry
extends NumberValueContainerEntry<Short> {
    private final ITextComponent displayName;
    private boolean bounds;

    public ShortValueContainerEntry(ITextComponent displayName, String name, short value) {
        this(displayName, name, value, Short.MIN_VALUE, Short.MAX_VALUE);
        this.bounds = false;
    }

    public ShortValueContainerEntry(ITextComponent displayName, String name, short value, short minValue, short maxValue) {
        super(name, value, minValue, maxValue);
        this.displayName = displayName;
        this.bounds = true;
    }

    @Override
    protected Short getValue(Number number) {
        return number.shortValue();
    }

    @Override
    protected Short clamp(Short value, Short minValue, Short maxValue) {
        if (value < minValue) {
            value = minValue;
        }
        if (value > maxValue) {
            value = maxValue;
        }
        return value;
    }

    @Override
    protected boolean hasBounds() {
        return this.bounds;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74777_a(this.getName(), ((Short)this.value).shortValue());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 2) ? Short.valueOf(nbt.func_74765_d(this.getName())) : (Short)this.getPreviousValue();
    }

    @Override
    public boolean isDecimal() {
        return false;
    }
}

