/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.sonar.common.valuecontainer;

import io.github.ocelot.sonar.common.valuecontainer.AbstractVectorValueContainerEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.math.NumberUtils;

public class Vector3dValueContainerEntry
extends AbstractVectorValueContainerEntry<Vector3d> {
    public Vector3dValueContainerEntry(ITextComponent displayName, String name, Vector3d value) {
        this(displayName, name, value, null, null);
    }

    public Vector3dValueContainerEntry(ITextComponent displayName, String name, Vector3d value, Vector3d minValue, Vector3d maxValue) {
        super(displayName, name, value, minValue, maxValue, true);
    }

    @Override
    protected Vector3d create(Number x, Number y, Number z) {
        return new Vector3d(x.doubleValue(), y.doubleValue(), z.doubleValue());
    }

    @Override
    protected Number getX(Vector3d value) {
        return value.func_82615_a();
    }

    @Override
    protected Number getY(Vector3d value) {
        return value.func_82617_b();
    }

    @Override
    protected Number getZ(Vector3d value) {
        return value.func_82616_c();
    }

    @Override
    public void write(CompoundNBT nbt) {
        CompoundNBT valueNbt = new CompoundNBT();
        valueNbt.func_74780_a("x", ((Vector3d)this.value).func_82615_a());
        valueNbt.func_74780_a("y", ((Vector3d)this.value).func_82617_b());
        valueNbt.func_74780_a("z", ((Vector3d)this.value).func_82616_c());
        nbt.func_218657_a(this.getName(), (INBT)valueNbt);
    }

    @Override
    public void read(CompoundNBT nbt) {
        if (nbt.func_150297_b(this.getName(), 10)) {
            CompoundNBT valueNbt = nbt.func_74775_l(this.getName());
            this.value = new Vector3d(valueNbt.func_74769_h("x"), valueNbt.func_74769_h("y"), valueNbt.func_74769_h("z"));
        } else {
            this.value = new Vector3d(0.0, 0.0, 0.0);
        }
    }

    @Override
    public void parse(String data) {
        String[] tokens = String.valueOf(data).split(",");
        Number x = NumberUtils.createNumber((String)tokens[0].trim());
        Number y = NumberUtils.createNumber((String)tokens[1].trim());
        Number z = NumberUtils.createNumber((String)tokens[2].trim());
        this.value = this.clamp(new Vector3d(x.doubleValue(), y.doubleValue(), z.doubleValue()), this.getMinValue(), this.getMaxValue());
    }
}

