/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.pike;

import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.common.entity.BucketableWaterMobEntity;
import com.minecraftabnormals.upgrade_aquatic.api.util.UAEntityPredicates;
import com.minecraftabnormals.upgrade_aquatic.client.particle.UAParticles;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.PickerelweedBlock;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.PickerelweedDoublePlantBlock;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.PickerelweedPlantBlock;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.PikeType;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.ai.HideInPickerelweedGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.ai.PikeAttackGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.ai.PikeSwimToItemsGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.pike.ai.PikeTemptGoal;
import com.minecraftabnormals.upgrade_aquatic.core.other.UADataSerializers;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class PikeEntity
extends BucketableWaterMobEntity {
    private static final DataParameter<PikeType> TYPE = EntityDataManager.func_187226_a(PikeEntity.class, UADataSerializers.PIKE_TYPE);
    private static final DataParameter<Boolean> DROP_ITEM = EntityDataManager.func_187226_a(PikeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(PikeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> LIT = EntityDataManager.func_187226_a(PikeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ATTACK_COOLDOWN = EntityDataManager.func_187226_a(PikeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Predicate<ItemEntity> ITEM_SELECTOR = entity -> !entity.func_174874_s() && entity.func_70089_S() && entity.func_70090_H() && entity.func_92059_d().func_77973_b().func_206844_a((ITag)ItemTags.field_206964_G);
    private int eatTicks;
    private int dropEatingLootCooldown;

    public PikeEntity(EntityType<? extends PikeEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184598_c(Hand.MAIN_HAND);
        this.func_98053_h(true);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.9);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        if (this.getPikeType() != PikeType.SPECTRAL) {
            this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal<PikeEntity>((CreatureEntity)this, PikeEntity.class, 8.0f, 1.6, 1.4, UAEntityPredicates.IS_SPECTRAL::test){

                public boolean func_75250_a() {
                    return super.func_75250_a() && this.field_75380_a != null && ((PikeEntity)this.field_75380_a).getPikeType() != PikeType.SPECTRAL;
                }
            });
        }
        this.field_70714_bg.func_75776_a(3, (Goal)new PikeTemptGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.1, 40){

            public boolean func_75250_a() {
                return ((PikeEntity)this.field_75457_a).isHidingInPickerelweed() ? super.func_75250_a() && this.field_75457_a.func_70681_au().nextInt(6) == 0 : super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new HideInPickerelweedGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new PikeSwimToItemsGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new PikeAttackGoal((CreatureEntity)this, 12.0, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<AbstractFishEntity>((MobEntity)this, AbstractFishEntity.class, true){

            public boolean func_75250_a() {
                return ((PikeEntity)this.field_75299_d).getAttackCooldown() <= 0 && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<TurtleEntity>((MobEntity)this, TurtleEntity.class, 10, true, false, UAEntityPredicates.IS_CHILD::test){

            public boolean func_75250_a() {
                return ((PikeEntity)this.field_75299_d).getAttackCooldown() <= 0 && super.func_75250_a();
            }
        });
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)PikeType.AMUR);
        this.field_70180_af.func_187214_a(DROP_ITEM, (Object)true);
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(LIT, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_COOLDOWN, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.equals(TYPE)) {
            this.func_213323_x_();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("PikeType", this.getPikeType().id);
        compound.func_74768_a("AttackCooldown", this.getAttackCooldown());
        compound.func_74768_a("EatingLootDropCooldown", this.dropEatingLootCooldown);
        compound.func_74757_a("DoesDropItem", this.shouldDropItem());
        compound.func_74757_a("Lit", this.isLit());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPikeType(PikeType.getTypeById(MathHelper.func_76125_a((int)compound.func_74762_e("PikeType"), (int)1, (int)21)));
        this.dropEatingLootCooldown = compound.func_74762_e("EatingLootDropCooldown");
        this.setAttackCooldown(compound.func_74762_e("AttackCooldown"));
        this.setToDropItem(compound.func_74767_n("DoesDropItem"));
        this.setLit(compound.func_74767_n("Lit"));
    }

    public void func_70636_d() {
        int i;
        LivingEntity caughtEntity;
        super.func_70636_d();
        ++this.eatTicks;
        if (this.dropEatingLootCooldown > 0) {
            --this.dropEatingLootCooldown;
        }
        if (!this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
        }
        if (this.field_70170_p.func_82737_E() % 20L == 0L && (caughtEntity = this.getCaughtEntity()) != null && (!this.isPickerelweedNearby() || this.isHidingInPickerelweed())) {
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_219632_dv, SoundCategory.HOSTILE, 0.8f, 0.9f);
            if (this.field_70170_p.field_72995_K && caughtEntity.func_110143_aJ() <= 1.0f && this.getPikeType() == PikeType.SPECTRAL) {
                for (i = 0; i < 3; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)UAParticles.SPECTRAL_CONSUME.get(), caughtEntity.func_226277_ct_() + (caughtEntity.func_70681_au().nextDouble() - 0.5) * (double)caughtEntity.func_213311_cf(), caughtEntity.func_226278_cu_() + caughtEntity.func_70681_au().nextDouble() * (double)caughtEntity.func_213302_cg() - 0.25, caughtEntity.func_226281_cx_() + (caughtEntity.func_70681_au().nextDouble() - 0.5) * (double)caughtEntity.func_213311_cf(), (this.getCaughtEntity().func_70681_au().nextDouble() - 0.5) * 2.0, -caughtEntity.func_70681_au().nextDouble(), (caughtEntity.func_70681_au().nextDouble() - 0.5) * 2.0);
                }
            }
            caughtEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
        }
        if (this.getAttackCooldown() > 0) {
            this.setAttackCooldown(this.getAttackCooldown() - 1);
        }
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW() && !itemstack.func_190926_b() && this.canEatItem(itemstack) && this.func_70090_H()) {
            if (this.eatTicks > 600) {
                ItemStack itemstackFood = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                if (!itemstack.func_190926_b()) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, itemstackFood);
                }
                if (this.dropEatingLootCooldown <= 0) {
                    if (this.field_70146_Z.nextFloat() < 0.2f) {
                        for (ItemStack stacks : this.generateFishingLoot((ServerWorld)this.field_70170_p)) {
                            if (stacks.func_190916_E() > 0) {
                                stacks.func_190918_g(stacks.func_190916_E() - 1);
                            }
                            this.spitOutItem(stacks);
                        }
                    } else {
                        this.spitOutItem(new ItemStack((IItemProvider)Items.field_196106_bc));
                    }
                    this.dropEatingLootCooldown = 3600 + this.func_70681_au().nextInt(400);
                }
                this.func_70691_i(6.0f);
                this.eatTicks = 0;
            } else if (this.eatTicks > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                this.func_184185_a(this.func_213353_d(itemstack), 1.0f, 1.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)45);
            }
        }
        if (this.isMoving() && this.func_70090_H() && this.getPikeType() == PikeType.SUPERCHARGED) {
            Vector3d vec3d1 = this.func_70676_i(0.0f);
            for (int i2 = 0; i2 < 2; ++i2) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d1.field_72450_a * 1.5, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - vec3d1.field_72448_b * 1.5, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d1.field_72449_c * 1.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.getPikeType() == PikeType.OBSIDIAN && this.isLit() && this.field_70170_p.field_72995_K) {
            for (i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            float speed = this.getPikeType() == PikeType.SUPERCHARGED ? 0.05f : 0.01f;
            this.func_213309_a(speed, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entitySource = source.func_76346_g();
        if (!(this.hasCaughtEntity() || !(entitySource instanceof LivingEntity) || entitySource instanceof PlayerEntity && ((PlayerEntity)entitySource).field_71075_bZ.field_75098_d)) {
            this.func_70624_b((LivingEntity)source.func_76346_g());
            return super.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        int type = PikeType.getRandom((Random)this.field_70146_Z, (Biome.Category)this.field_70170_p.func_226691_t_((BlockPos)this.func_233580_cy_()).func_201856_r(), (boolean)(reason == SpawnReason.BUCKET ? true : false)).id;
        if (dataTag != null && dataTag.func_150297_b("BucketVariantTag", 3)) {
            this.setPikeType(PikeType.getTypeById(dataTag.func_74762_e("BucketVariantTag")));
            this.dropEatingLootCooldown = dataTag.func_74762_e("EatingLootDropCooldown");
            if (dataTag.func_74764_b("PikeHeldItem")) {
                this.func_184598_c(Hand.MAIN_HAND);
                this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.func_199557_a((CompoundNBT)dataTag.func_74775_l("PikeHeldItem")));
            }
            if (dataTag.func_74764_b("ShouldDropItem")) {
                this.setToDropItem(dataTag.func_74767_n("ShouldDropItem"));
            }
            if (dataTag.func_74764_b("IsLit")) {
                this.setLit(dataTag.func_74767_n("IsLit"));
            }
            return spawnDataIn;
        }
        if (spawnDataIn instanceof PikeData) {
            type = ((PikeData)spawnDataIn).typeData;
        } else if (!this.isFromBucket()) {
            spawnDataIn = new PikeData(type);
        }
        this.setPikeType(PikeType.getTypeById(type));
        if (this.field_70146_Z.nextFloat() <= 0.1f && this.func_70613_aW()) {
            List<ItemStack> generatedFishingLoot = this.generateFishingLoot((ServerWorld)this.field_70170_p);
            for (ItemStack itemstack : generatedFishingLoot) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
            }
            this.setToDropItem(false);
        }
        this.func_213323_x_();
        return spawnDataIn;
    }

    public static boolean pickerelCondition(EntityType<? extends PikeEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (((World)world).func_234923_W_() != World.field_234918_g_) {
            return false;
        }
        for (int yy = pos.func_177956_o() - 2; yy <= pos.func_177956_o() + 2; ++yy) {
            for (int xx = pos.func_177958_n() - 6; xx <= pos.func_177958_n() + 6; ++xx) {
                for (int zz = pos.func_177952_p() - 6; zz <= pos.func_177952_p() + 6; ++zz) {
                    if (!(world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof PickerelweedPlantBlock) && !(world.func_180495_p(new BlockPos(xx, yy, zz)).func_177230_c() instanceof PickerelweedDoublePlantBlock)) continue;
                    if (random.nextFloat() <= 0.125f && world.func_226691_t_(pos).func_201856_r() == Biome.Category.SWAMP) {
                        return random.nextFloat() <= 0.25f;
                    }
                    return true;
                }
            }
        }
        return random.nextFloat() <= 0.05f;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            itemstack.func_222118_a(1, (LivingEntity)player, onBroken -> onBroken.func_213334_d(hand));
            this.func_184185_a(SoundEvents.field_187649_bu, 1.0f, 1.0f);
            this.setLit(true);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn){

            protected boolean func_75485_k() {
                return super.func_75485_k() || this.field_75515_a.func_213339_cH().func_177230_c() instanceof PickerelweedBlock;
            }

            public boolean func_188555_b(BlockPos pos) {
                return super.func_188555_b(pos) || this.field_75515_a.func_213339_cH().func_177230_c() instanceof PickerelweedBlock;
            }
        };
    }

    public ItemStack getBucket() {
        return new ItemStack((IItemProvider)UAItems.PIKE_BUCKET.get());
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CompoundNBT compoundnbt = bucket.func_196082_o();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        compoundnbt.func_74768_a("BucketVariantTag", this.getPikeType().id);
        compoundnbt.func_74768_a("EatingLootDropCooldown", this.dropEatingLootCooldown);
        if (!this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
            this.func_184582_a(EquipmentSlotType.MAINHAND).func_77955_b(compoundnbt1);
        }
        compoundnbt.func_218657_a("PikeHeldItem", (INBT)compoundnbt1);
        compoundnbt.func_74757_a("ShouldDropItem", this.shouldDropItem());
        compoundnbt.func_74757_a("IsLit", this.isLit());
    }

    @Nullable
    public LivingEntity getCaughtEntity() {
        List passengers = this.func_184188_bt();
        if (!passengers.isEmpty()) {
            Entity passenger = (Entity)passengers.get(0);
            return passenger instanceof AbstractFishEntity || passenger instanceof AnimalEntity ? (LivingEntity)passenger : null;
        }
        return null;
    }

    public boolean hasCaughtEntity() {
        return this.getCaughtEntity() != null;
    }

    public void spitOutItem(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)itementity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
    }

    private boolean canEatItem(ItemStack itemstack) {
        return itemstack.func_77973_b().func_206844_a((ITag)ItemTags.field_206964_G);
    }

    public boolean isPickerelweedNearby() {
        return this.getNearbyPickerelweeds().size() > 0;
    }

    public boolean isHidingInPickerelweed() {
        return this.func_130014_f_().func_180495_p(this.func_233580_cy_()).func_177230_c() instanceof PickerelweedPlantBlock || this.func_130014_f_().func_180495_p(this.func_233580_cy_()).func_177230_c() instanceof PickerelweedDoublePlantBlock;
    }

    public List<BlockPos> getNearbyPickerelweeds() {
        ArrayList pickerelweeds = Lists.newArrayList();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int yy = this.func_233580_cy_().func_177956_o() - 6;
        while ((double)yy <= this.func_226278_cu_() + 6.0) {
            int xx = this.func_233580_cy_().func_177958_n() - 12;
            while ((double)xx <= this.func_226277_ct_() + 12.0) {
                int zz = this.func_233580_cy_().func_177952_p() - 12;
                while ((double)zz <= this.func_226281_cx_() + 12.0) {
                    mutable.func_181079_c(xx, yy, zz);
                    Block block = this.field_70170_p.func_180495_p((BlockPos)mutable).func_177230_c();
                    if (block instanceof PickerelweedPlantBlock || block instanceof PickerelweedDoublePlantBlock) {
                        pickerelweeds.add(mutable);
                    }
                    ++zz;
                }
                ++xx;
            }
            ++yy;
        }
        return pickerelweeds;
    }

    private List<ItemStack> generateFishingLoot(ServerWorld world) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)new ItemStack((IItemProvider)Items.field_151112_aM)).func_216023_a(this.field_70146_Z).func_186469_a(2.0f);
        lootcontext$builder.func_216015_a(LootParameters.field_216284_d, (Object)this).func_216015_a(LootParameters.field_216281_a, (Object)this);
        LootTable loottable = this.func_70681_au().nextFloat() >= 0.1f ? this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186388_am) : this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186389_an);
        return loottable.func_216113_a(lootcontext$builder.func_216022_a(LootParameterSets.field_216262_c));
    }

    public int func_70641_bl() {
        return 3;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.6f;
    }

    public boolean func_98052_bS() {
        return this.func_70090_H() && super.func_98052_bS();
    }

    protected float func_205712_c(EquipmentSlotType p_205712_1_) {
        return this.shouldDropItem() ? 100.0f : 0.0f;
    }

    public boolean func_213365_e(ItemStack p_213365_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)p_213365_1_);
        if (!this.func_184582_a(equipmentslottype).func_190926_b()) {
            return false;
        }
        return equipmentslottype == EquipmentSlotType.MAINHAND && super.func_213365_e(p_213365_1_);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_175448_a(itemstack) && !this.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b().func_206844_a((ITag)ItemTags.field_206964_G)) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.spawnItem(itemstack.func_77979_a(i - 1));
            }
            this.spitOutItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    private void spawnItem(ItemStack stack) {
        this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stack));
    }

    public void func_71001_a(Entity entityIn, int quantity) {
        super.func_71001_a(entityIn, quantity);
        this.setToDropItem(true);
    }

    public void func_184232_k(Entity passenger) {
        if (passenger instanceof AbstractFishEntity || passenger instanceof AnimalEntity) {
            float distance = 0.7f;
            double dx = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0) * (double)distance;
            Vector3d riderPos = new Vector3d(this.func_226277_ct_() + dx, this.func_226278_cu_() + this.func_70042_X() + ((Entity)this.func_184188_bt().get(0)).func_70033_W(), this.func_226281_cx_() + dz);
            passenger.func_70107_b(riderPos.field_72450_a, riderPos.field_72448_b, riderPos.field_72449_c);
        } else {
            super.func_184232_k(passenger);
        }
    }

    public double func_70042_X() {
        return (double)this.func_213305_a((Pose)this.func_213283_Z()).field_220316_b * 0.075;
    }

    public boolean func_205710_ba() {
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAItems.PIKE_SPAWN_EGG.get());
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.getPikeType().pikeSize.boxSize);
    }

    public boolean isLit() {
        return (Boolean)this.field_70180_af.func_187225_a(LIT);
    }

    private void setLit(boolean lit) {
        this.field_70180_af.func_187227_b(LIT, (Object)lit);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    private void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    public int getAttackCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(ATTACK_COOLDOWN);
    }

    public void setAttackCooldown(int ticks) {
        this.field_70180_af.func_187227_b(ATTACK_COOLDOWN, (Object)ticks);
    }

    public boolean shouldDropItem() {
        return (Boolean)this.field_70180_af.func_187225_a(DROP_ITEM);
    }

    public void setToDropItem(boolean bool) {
        this.field_70180_af.func_187227_b(DROP_ITEM, (Object)bool);
    }

    public PikeType getPikeType() {
        return (PikeType)((Object)this.field_70180_af.func_187225_a(TYPE));
    }

    public void setPikeType(PikeType type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203820_gM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203821_gN;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203823_gP;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203822_gO;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    static class PikeData
    implements ILivingEntityData {
        public final int typeData;

        public PikeData(int type) {
            this.typeData = type;
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final PikeEntity pike;

        MoveHelperController(PikeEntity pike) {
            super((MobEntity)pike);
            this.pike = pike;
        }

        public void func_75641_c() {
            if (this.pike.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.pike.func_213317_d(this.pike.func_213322_ci().func_72441_c(0.0, 0.001, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.pike.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.pike.func_226277_ct_();
                double d1 = this.field_75647_c - this.pike.func_226278_cu_();
                double d2 = this.field_75644_d - this.pike.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.pike.field_70761_aq = this.pike.field_70177_z = this.func_75639_a(this.pike.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.pike.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                this.pike.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.pike.func_70689_ay(), (float)f1));
                this.pike.func_213317_d(this.pike.func_213322_ci().func_72441_c(0.0, (double)this.pike.func_70689_ay() * (d1 /= d3) * 0.04, 0.0));
                this.pike.setMoving(true);
            } else {
                if (this.pike.getPikeType() == PikeType.SUPERCHARGED) {
                    this.pike.func_70659_e(0.0f);
                }
                this.pike.setMoving(false);
            }
        }
    }
}

