/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature;

import com.minecraftabnormals.abnormals_core.core.util.MathUtil;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.PickerelweedDoublePlantBlock;
import com.minecraftabnormals.upgrade_aquatic.common.blocks.PickerelweedPlantBlock;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PickerelweedFeature
extends Feature<NoFeatureConfig> {
    private static final Supplier<BlockState> BLUE_PICKERELWEED = () -> ((Block)UABlocks.BLUE_PICKERELWEED.get()).func_176223_P();
    private static final Supplier<BlockState> PURPLE_PICKERELWEED = () -> ((Block)UABlocks.PURPLE_PICKERELWEED.get()).func_176223_P();

    public PickerelweedFeature(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        Biome biome = worldIn.func_226691_t_(pos);
        if (this.isValidBlock((IWorld)worldIn, pos) && this.shouldPlace((IWorld)worldIn, pos) && BLUE_PICKERELWEED.get().func_196955_c((IWorldReader)worldIn, pos.func_177977_b())) {
            if (biome.func_201856_r() == Biome.Category.RIVER || biome.func_201856_r() == Biome.Category.SWAMP || biome.getRegistryName().equals((Object)Biomes.field_185444_T.func_240901_a_())) {
                boolean purpleGen;
                if (biome.func_201856_r() == Biome.Category.SWAMP) {
                    purpleGen = (double)rand.nextFloat() >= 0.6;
                } else {
                    boolean bl = purpleGen = !((double)rand.nextFloat() >= 0.6);
                }
                if ((double)rand.nextInt() <= 0.9) {
                    this.generatePickerelweedPatch((IWorld)worldIn, pos, purpleGen, rand.nextInt(8));
                }
            } else {
                boolean purpleGen;
                if ((double)biome.func_242445_k() < 0.2) {
                    purpleGen = (double)rand.nextFloat() >= 0.75;
                } else if ((double)biome.func_242445_k() < 1.0) {
                    purpleGen = rand.nextBoolean();
                } else {
                    boolean bl = purpleGen = !((double)rand.nextFloat() >= 0.75);
                }
                if ((double)rand.nextInt() <= 0.35) {
                    this.generatePickerelweedPatch((IWorld)worldIn, pos, purpleGen, rand.nextInt(8));
                }
            }
            return true;
        }
        return false;
    }

    public void generatePickerelweedPatch(IWorld world, BlockPos pos, boolean purple, int randomDesign) {
        int[] patterns = new int[3];
        switch (randomDesign) {
            default: {
                patterns[0] = 4;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 1: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 9;
            }
            case 2: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 12;
            }
            case 3: {
                patterns[0] = 3;
                patterns[1] = 13;
                patterns[2] = 12;
            }
            case 4: {
                patterns[0] = 4;
                patterns[1] = 3;
                patterns[2] = 6;
            }
            case 5: {
                patterns[0] = 3;
                patterns[1] = 4;
                patterns[2] = 6;
            }
            case 6: {
                patterns[0] = 5;
                patterns[1] = 4;
                patterns[2] = 6;
            }
            case 7: 
        }
        patterns[0] = 5;
        patterns[1] = 4;
        patterns[2] = 6;
        BlockPos startPos = pos;
        PickerelweedDoublePlantBlock doubleplantblock = (PickerelweedDoublePlantBlock)(!purple ? (Block)UABlocks.TALL_BLUE_PICKERELWEED.get() : (Block)UABlocks.TALL_PURPLE_PICKERELWEED.get());
        MathUtil.Equation r = theta -> (Math.cos((double)patterns[1] * theta) / (double)patterns[2] + 1.0) * (double)patterns[0];
        if (!(world.func_175623_d(startPos.func_177977_b()) || world.func_175623_d(startPos.func_177979_c(2)) || world.func_175623_d(startPos.func_177979_c(3)))) {
            int repeatsDown = world.func_201674_k().nextInt(2) + 2;
            for (int repeats = 0; repeats < repeatsDown; ++repeats) {
                pos = pos.func_177982_a(0, -repeats, 0);
                for (int i = -(patterns[0] / patterns[2] + patterns[0]); i < patterns[0] / patterns[2] + patterns[0]; ++i) {
                    for (int j = -(patterns[0] / patterns[2] + patterns[0]); j < patterns[0] / patterns[2] + patterns[0]; ++j) {
                        double radius = r.compute(Math.atan2(j, i));
                        BlockPos placingPos = pos.func_177982_a(i, 0, j);
                        if (!world.func_180495_p(placingPos).func_185904_a().func_76222_j() || !((double)(i * i + j * j) < radius * radius)) continue;
                        if ((double)(i * i + j * j) > (radius - 1.0) * (radius - 1.0)) {
                            FluidState ifluidstate = world.func_204610_c(placingPos);
                            if (PURPLE_PICKERELWEED.get().func_196955_c((IWorldReader)world, placingPos) && world.func_180495_p(placingPos.func_177984_a()).func_185904_a().func_76222_j() && world.func_201674_k().nextDouble() <= 0.85) {
                                if (purple) {
                                    world.func_180501_a(placingPos, (BlockState)PURPLE_PICKERELWEED.get().func_206870_a((Property)PickerelweedPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a))), 2);
                                    continue;
                                }
                                world.func_180501_a(placingPos, (BlockState)BLUE_PICKERELWEED.get().func_206870_a((Property)PickerelweedPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a))), 2);
                                continue;
                            }
                            if (!PURPLE_PICKERELWEED.get().func_196955_c((IWorldReader)world, placingPos)) continue;
                            doubleplantblock.placeAt(world, placingPos, 2);
                            continue;
                        }
                        if (!doubleplantblock.func_176223_P().func_196955_c((IWorldReader)world, placingPos)) continue;
                        doubleplantblock.placeAt(world, placingPos, 2);
                    }
                }
            }
        }
    }

    public boolean isValidBlock(IWorld world, BlockPos pos) {
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public boolean shouldPlace(IWorld world, BlockPos pos) {
        return world.func_204610_c(pos.func_177977_b().func_177976_e()).func_206884_a((ITag)FluidTags.field_206959_a) || world.func_204610_c(pos.func_177977_b().func_177974_f()).func_206884_a((ITag)FluidTags.field_206959_a) || world.func_204610_c(pos.func_177977_b().func_177978_c()).func_206884_a((ITag)FluidTags.field_206959_a) || world.func_204610_c(pos.func_177977_b().func_177968_d()).func_206884_a((ITag)FluidTags.field_206959_a);
    }
}

