/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.better_badlands.common.world.gen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.IPlantable;

public class SmallDarkOakFeature
extends Feature<BaseTreeFeatureConfig> {
    public SmallDarkOakFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    @ParametersAreNonnullByDefault
    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, BaseTreeFeatureConfig config) {
        int height = rand.nextInt(3) + 3;
        int splitHeight = rand.nextInt(height - 2) + 2;
        int randDir = rand.nextInt(4);
        Direction direction = Direction.func_176731_b((int)randDir);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 2 <= worldIn.func_217301_I()) {
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)position.func_177982_a(-1, 1, -1), (BlockPos)position.func_177982_a(1, height, 1))) {
                if (SmallDarkOakFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, pos)) continue;
                flag = false;
                break;
            }
            if (!SmallDarkOakFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, position)) {
                flag = false;
            }
            if (!flag) {
                return false;
            }
            if (SmallDarkOakFeature.isValidGround((IWorld)worldIn, position.func_177977_b())) {
                ArrayList<BlockPos> logPos = new ArrayList<BlockPos>();
                ArrayList<BlockPos> leafPos = new ArrayList<BlockPos>();
                SmallDarkOakFeature.setDirtAt((IWorld)worldIn, position.func_177977_b());
                for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)position, (BlockPos)position.func_177981_b(splitHeight))) {
                    this.placeLogAt((IWorldWriter)worldIn, blockPos, rand, config, logPos);
                }
                for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)position.func_177972_a(direction).func_177981_b(splitHeight), (BlockPos)position.func_177972_a(direction).func_177981_b(height))) {
                    this.placeLogAt((IWorldWriter)worldIn, blockPos, rand, config, logPos);
                }
                this.placeLeavesAt(worldIn, position.func_177972_a(direction).func_177981_b(height), direction, rand, config, leafPos);
                HashSet decSet = Sets.newHashSet();
                MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_78887_a();
                if (!config.field_227370_o_.isEmpty()) {
                    logPos.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                    leafPos.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                    config.field_227370_o_.forEach(decorator -> decorator.func_225576_a_(worldIn, rand, logPos, leafPos, decSet, mutableBoundingBox));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLeavesAt(ISeedReader worldIn, BlockPos pos, Direction dir, Random rand, BaseTreeFeatureConfig config, List<BlockPos> leaf) {
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            this.placeLeafAt((IWorldGenerationReader)worldIn, blockPos, rand, config, leaf);
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, 0, -1), (BlockPos)pos.func_177982_a(-2, 0, 1))) {
            this.placeLeafAt((IWorldGenerationReader)worldIn, blockPos, rand, config, leaf);
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(2, 0, -1), (BlockPos)pos.func_177982_a(2, 0, 1))) {
            this.placeLeafAt((IWorldGenerationReader)worldIn, blockPos, rand, config, leaf);
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, -2), (BlockPos)pos.func_177982_a(1, 0, -2))) {
            this.placeLeafAt((IWorldGenerationReader)worldIn, blockPos, rand, config, leaf);
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, 2), (BlockPos)pos.func_177982_a(1, 0, 2))) {
            this.placeLeafAt((IWorldGenerationReader)worldIn, blockPos, rand, config, leaf);
        }
        this.placeLeafAt((IWorldGenerationReader)worldIn, pos.func_177982_a(-2, 1, 0), rand, config, leaf);
        this.placeLeafAt((IWorldGenerationReader)worldIn, pos.func_177982_a(2, 1, 0), rand, config, leaf);
        this.placeLeafAt((IWorldGenerationReader)worldIn, pos.func_177982_a(0, 1, -2), rand, config, leaf);
        this.placeLeafAt((IWorldGenerationReader)worldIn, pos.func_177982_a(0, 1, 2), rand, config, leaf);
        this.placeLeafAt((IWorldGenerationReader)worldIn, pos.func_177981_b(2), rand, config, leaf);
        this.placeLeafAt((IWorldGenerationReader)worldIn, pos.func_177967_a(dir, 3), rand, config, leaf);
        this.placeRandomLeafAt((IWorldGenerationReader)worldIn, pos.func_177981_b(2).func_177972_a(dir), rand, config, leaf);
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, -1).func_177967_a(dir, 2), (BlockPos)pos.func_177982_a(1, 0, 1).func_177967_a(dir, 2))) {
            this.placeRandomLeafAt((IWorldGenerationReader)worldIn, blockPos, rand, config, leaf);
        }
        this.placeRandomLeafAt((IWorldGenerationReader)worldIn, pos.func_177977_b().func_177967_a(dir, -2), rand, config, leaf);
    }

    private void placeLogAt(IWorldWriter worldIn, BlockPos pos, Random rand, BaseTreeFeatureConfig config, List<BlockPos> log) {
        this.setLogState(worldIn, pos, config.field_227368_m_.func_225574_a_(rand, pos));
        log.add(pos);
    }

    private void placeRandomLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, BaseTreeFeatureConfig config, List<BlockPos> leaf) {
        if (rand.nextBoolean()) {
            this.placeLeafAt(world, pos, rand, config, leaf);
        }
    }

    private void placeLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, BaseTreeFeatureConfig config, List<BlockPos> leaf) {
        if (SmallDarkOakFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, pos)) {
            this.setLogState((IWorldWriter)world, pos, (BlockState)config.field_227369_n_.func_225574_a_(rand, pos).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
            leaf.add(pos);
        }
    }

    protected final void setLogState(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, state, 18);
    }

    public static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (worldIn instanceof IWorldReader) {
            return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
        }
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public static void setDirtAt(IWorld worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_196658_i || block == Blocks.field_150458_ak) {
            worldIn.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 16);
        }
    }

    public static boolean isValidGround(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)Blocks.field_196680_y);
    }
}

