/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.better_badlands.common.world.gen.foliageplacer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class SmallDarkOakFoliagePlacer
extends FoliagePlacer {
    public static final Codec<SmallDarkOakFoliagePlacer> field_236745_a_ = RecordCodecBuilder.create(p_236746_0_ -> SmallDarkOakFoliagePlacer.func_242830_b((RecordCodecBuilder.Instance)p_236746_0_).apply((Applicative)p_236746_0_, SmallDarkOakFoliagePlacer::new));

    public SmallDarkOakFoliagePlacer(FeatureSpread p_i241997_1_, FeatureSpread p_i241997_2_) {
        super(p_i241997_1_, p_i241997_2_);
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return FoliagePlacerType.field_227389_d_;
    }

    protected void func_230372_a_(IWorldGenerationReader worldIn, Random rand, BaseTreeFeatureConfig config, int trunkHeight, FoliagePlacer.Foliage treeNode, int foliageHeight, int radius, Set<BlockPos> leaf, int offset, MutableBoundingBox box) {
        BlockPos pos = treeNode.func_236763_a_().func_177981_b(offset);
        Direction dir = Direction.func_176731_b((int)rand.nextInt(4));
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            this.placeLeafAt(worldIn, blockPos, rand, config, leaf);
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, 0, -1), (BlockPos)pos.func_177982_a(-2, 0, 1))) {
            this.placeLeafAt(worldIn, blockPos, rand, config, leaf);
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(2, 0, -1), (BlockPos)pos.func_177982_a(2, 0, 1))) {
            this.placeLeafAt(worldIn, blockPos, rand, config, leaf);
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, -2), (BlockPos)pos.func_177982_a(1, 0, -2))) {
            this.placeLeafAt(worldIn, blockPos, rand, config, leaf);
        }
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, 2), (BlockPos)pos.func_177982_a(1, 0, 2))) {
            this.placeLeafAt(worldIn, blockPos, rand, config, leaf);
        }
        this.placeLeafAt(worldIn, pos.func_177982_a(-2, 1, 0), rand, config, leaf);
        this.placeLeafAt(worldIn, pos.func_177982_a(2, 1, 0), rand, config, leaf);
        this.placeLeafAt(worldIn, pos.func_177982_a(0, 1, -2), rand, config, leaf);
        this.placeLeafAt(worldIn, pos.func_177982_a(0, 1, 2), rand, config, leaf);
        this.placeLeafAt(worldIn, pos.func_177981_b(2), rand, config, leaf);
        this.placeLeafAt(worldIn, pos.func_177967_a(dir, 3), rand, config, leaf);
        this.placeRandomLeafAt(worldIn, pos.func_177981_b(2).func_177972_a(dir), rand, config, leaf);
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 0, -1).func_177967_a(dir, 2), (BlockPos)pos.func_177982_a(1, 0, 1).func_177967_a(dir, 2))) {
            this.placeRandomLeafAt(worldIn, blockPos, rand, config, leaf);
        }
        this.placeRandomLeafAt(worldIn, pos.func_177977_b().func_177967_a(dir, -2), rand, config, leaf);
    }

    private void placeRandomLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, BaseTreeFeatureConfig config, Set<BlockPos> leaf) {
        if (rand.nextBoolean()) {
            this.placeLeafAt(world, pos, rand, config, leaf);
        }
    }

    private void placeLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, BaseTreeFeatureConfig config, Set<BlockPos> leaf) {
        if (SmallDarkOakFoliagePlacer.isAirOrLeaves((IWorldGenerationBaseReader)world, pos)) {
            this.setLogState((IWorldWriter)world, pos, (BlockState)config.field_227369_n_.func_225574_a_(rand, pos).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
            leaf.add(pos);
        }
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (worldIn instanceof IWorldReader) {
            return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
        }
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    protected final void setLogState(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, state, 18);
    }

    public int func_230374_a_(Random random, int trunkHeight, BaseTreeFeatureConfig config) {
        return 4;
    }

    protected boolean func_230373_a_(Random random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return y != 0 || !giantTrunk || dx != -radius && dx < radius || dz != -radius && dz < radius ? super.func_230375_b_(random, dx, y, dz, radius, giantTrunk) : true;
    }

    protected boolean func_230375_b_(Random random, int baseHeight, int dx, int y, int dz, boolean giantTrunk) {
        if (dx == -1 && !giantTrunk) {
            return baseHeight == dz && y == dz;
        }
        if (dx == 1) {
            return baseHeight + y > dz * 2 - 2;
        }
        return false;
    }
}

