/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.better_badlands.core.registry;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.teamaurora.better_badlands.common.world.gen.feature.SmallDarkOakFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="better_badlands")
public class BetterBadlandsFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"better_badlands");
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> SMALL_DARK_OAK_TREE = FEATURES.register("small_dark_oak_tree", () -> new SmallDarkOakFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        List features = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
        if (event.getName() != null && ImmutableSet.of((Object)Biomes.field_150607_aa.func_240901_a_(), (Object)Biomes.field_185438_aj.func_240901_a_()).contains((Object)event.getName())) {
            ArrayList<Supplier> toRemove = new ArrayList<Supplier>();
            for (Supplier configuredFeatureSupplier : features) {
                IFeatureConfig config = ((ConfiguredFeature)configuredFeatureSupplier.get()).field_222738_b;
                if (!(config instanceof DecoratedFeatureConfig)) continue;
                ConfiguredFeature configuredFeature = (ConfiguredFeature)((DecoratedFeatureConfig)config).field_214689_a.get();
                if (configuredFeature.field_222737_a != Feature.field_236291_c_ || !(configuredFeature.field_222738_b instanceof BaseTreeFeatureConfig)) continue;
                toRemove.add(configuredFeatureSupplier);
            }
            toRemove.forEach(features::remove);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Configured.SMALL_DARK_OAK_TREE);
        }
    }

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> SMALL_DARK_OAK_TREE = ((Feature)SMALL_DARK_OAK_TREE.get()).func_225566_b_((IFeatureConfig)Configs.SMALL_DARK_OAK_TREE_CONFIG).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(5, 0.1f, 1)));

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("better_badlands", name), configuredFeature);
        }

        public static void registerConfiguredFeatures() {
            Configured.register("small_dark_oak_tree", SMALL_DARK_OAK_TREE);
        }
    }

    public static final class Configs {
        public static final BaseTreeFeatureConfig SMALL_DARK_OAK_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(BlockStates.DARK_OAK_LOG), (BlockStateProvider)new SimpleBlockStateProvider(BlockStates.DARK_OAK_LEAVES), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_225568_b_();
    }

    public static final class BlockStates {
        public static final BlockState DARK_OAK_LOG = Blocks.field_196623_P.func_176223_P();
        public static final BlockState DARK_OAK_LEAVES = Blocks.field_196574_ab.func_176223_P();
    }
}

