/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.enhanced_mushrooms.core.registry;

import com.teamaurora.enhanced_mushrooms.core.registry.EMBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enhanced_mushrooms")
public class EMFeatures {
    private static boolean isHugeRedMushroom(ConfiguredFeature<?, ?> configuredFeature) {
        if (configuredFeature.field_222737_a == Feature.field_202318_R) {
            if (configuredFeature.field_222738_b instanceof BigMushroomFeatureConfig) {
                BigMushroomFeatureConfig config = (BigMushroomFeatureConfig)configuredFeature.field_222738_b;
                return config.field_227272_a_.func_225574_a_(new Random(), new BlockPos(0, 0, 0)).func_177230_c() == Blocks.field_150419_aX;
            }
            return false;
        }
        return false;
    }

    private static boolean isHugeBrownMushroom(ConfiguredFeature<?, ?> configuredFeature) {
        if (configuredFeature.field_222737_a == Feature.field_202319_S) {
            if (configuredFeature.field_222738_b instanceof BigMushroomFeatureConfig) {
                BigMushroomFeatureConfig config = (BigMushroomFeatureConfig)configuredFeature.field_222738_b;
                return config.field_227272_a_.func_225574_a_(new Random(), new BlockPos(0, 0, 0)).func_177230_c() == Blocks.field_150420_aW;
            }
            return false;
        }
        return false;
    }

    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        List features = event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION);
        if (event.getName() != null) {
            ArrayList<Supplier> toRemove = new ArrayList<Supplier>();
            ArrayList<ConfiguredFeature> toAdd = new ArrayList<ConfiguredFeature>();
            for (Supplier configuredFeatureSupplier : features) {
                ConfiguredFeature rightFeatureFinal;
                TwoFeatureChoiceConfig tempConfig;
                IFeatureConfig config = ((ConfiguredFeature)configuredFeatureSupplier.get()).field_222738_b;
                if (!(config instanceof DecoratedFeatureConfig)) continue;
                ConfiguredFeature configuredFeature = (ConfiguredFeature)((DecoratedFeatureConfig)config).field_214689_a.get();
                if (configuredFeature.field_222738_b instanceof MultipleRandomFeatureConfig) {
                    MultipleRandomFeatureConfig mrfconfig = (MultipleRandomFeatureConfig)configuredFeature.field_222738_b;
                    ConfiguredFeature tempDef = (ConfiguredFeature)mrfconfig.field_202452_d.get();
                    if (EMFeatures.isHugeRedMushroom(tempDef)) {
                        tempDef = Feature.field_202318_R.func_225566_b_((IFeatureConfig)Configs.RED_MUSHROOM_CONFIG);
                    } else if (EMFeatures.isHugeBrownMushroom(tempDef)) {
                        tempDef = Feature.field_202319_S.func_225566_b_((IFeatureConfig)Configs.BROWN_MUSHROOM_CONFIG);
                    }
                    ArrayList<ConfiguredRandomFeatureList> tempFeatures = new ArrayList<ConfiguredRandomFeatureList>();
                    for (ConfiguredRandomFeatureList crfl : mrfconfig.field_202449_a) {
                        ConfiguredFeature crflFeature = (ConfiguredFeature)crfl.field_214842_a.get();
                        if (EMFeatures.isHugeRedMushroom(crflFeature)) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_202318_R.func_225566_b_((IFeatureConfig)Configs.RED_MUSHROOM_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        if (EMFeatures.isHugeBrownMushroom(crflFeature)) {
                            tempFeatures.add(new ConfiguredRandomFeatureList(Feature.field_202319_S.func_225566_b_((IFeatureConfig)Configs.BROWN_MUSHROOM_CONFIG), crfl.field_214844_c));
                            continue;
                        }
                        tempFeatures.add(crfl);
                    }
                    MultipleRandomFeatureConfig tempConfig2 = new MultipleRandomFeatureConfig(tempFeatures, tempDef);
                    if (tempConfig2 == mrfconfig) continue;
                    toRemove.add(configuredFeatureSupplier);
                    Feature featureMRFC = configuredFeature.field_222737_a;
                    toAdd.add(featureMRFC.func_225566_b_((IFeatureConfig)tempConfig2).func_227228_a_(((DecoratedFeatureConfig)config).field_214690_b));
                    continue;
                }
                if (!(configuredFeature.field_222738_b instanceof TwoFeatureChoiceConfig)) continue;
                TwoFeatureChoiceConfig tfcconfig = (TwoFeatureChoiceConfig)configuredFeature.field_222738_b;
                ConfiguredFeature leftFeature = (ConfiguredFeature)tfcconfig.field_227285_a_.get();
                if (EMFeatures.isHugeRedMushroom(leftFeature)) {
                    leftFeature = Feature.field_202318_R.func_225566_b_((IFeatureConfig)Configs.RED_MUSHROOM_CONFIG);
                } else if (EMFeatures.isHugeBrownMushroom(leftFeature)) {
                    leftFeature = Feature.field_202319_S.func_225566_b_((IFeatureConfig)Configs.BROWN_MUSHROOM_CONFIG);
                }
                ConfiguredFeature leftFeatureFinal = leftFeature;
                ConfiguredFeature rightFeature = (ConfiguredFeature)tfcconfig.field_227286_b_.get();
                if (EMFeatures.isHugeRedMushroom(rightFeature)) {
                    rightFeature = Feature.field_202318_R.func_225566_b_((IFeatureConfig)Configs.RED_MUSHROOM_CONFIG);
                } else if (EMFeatures.isHugeBrownMushroom(rightFeature)) {
                    rightFeature = Feature.field_202319_S.func_225566_b_((IFeatureConfig)Configs.BROWN_MUSHROOM_CONFIG);
                }
                if ((tempConfig = new TwoFeatureChoiceConfig(() -> leftFeatureFinal, () -> EMFeatures.lambda$onBiomeLoad$1(rightFeatureFinal = rightFeature))) == tfcconfig) continue;
                toRemove.add(configuredFeatureSupplier);
                Feature featureTFCC = configuredFeature.field_222737_a;
                toAdd.add(featureTFCC.func_225566_b_((IFeatureConfig)tempConfig).func_227228_a_(((DecoratedFeatureConfig)config).field_214690_b));
            }
            toRemove.forEach(features::remove);
            for (ConfiguredFeature f : toAdd) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, f);
            }
        }
    }

    private static /* synthetic */ ConfiguredFeature lambda$onBiomeLoad$1(ConfiguredFeature rightFeatureFinal) {
        return rightFeatureFinal;
    }

    public static final class Configs {
        public static final BigMushroomFeatureConfig RED_MUSHROOM_CONFIG = new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(BlockStates.RED_MUSHROOM_CAP), (BlockStateProvider)new SimpleBlockStateProvider(BlockStates.RED_MUSHROOM_STEM), 2);
        public static final BigMushroomFeatureConfig BROWN_MUSHROOM_CONFIG = new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider(BlockStates.BROWN_MUSHROOM_CAP), (BlockStateProvider)new SimpleBlockStateProvider(BlockStates.BROWN_MUSHROOM_STEM), 3);
    }

    public static final class BlockStates {
        public static final BlockState RED_MUSHROOM_STEM = ((Block)EMBlocks.RED_MUSHROOM_STEM.get()).func_176223_P();
        public static final BlockState BROWN_MUSHROOM_STEM = ((Block)EMBlocks.BROWN_MUSHROOM_STEM.get()).func_176223_P();
        public static final BlockState RED_MUSHROOM_CAP = (BlockState)Blocks.field_150419_aX.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false));
        public static final BlockState BROWN_MUSHROOM_CAP = (BlockState)((BlockState)Blocks.field_150420_aW.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false));
    }
}

