/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.properties.blocks;

import corgiaoc.byg.common.world.feature.end.EndVegetationFeature;
import corgiaoc.byg.common.world.feature.overworld.OverworldVegetationFeature;
import corgiaoc.byg.core.BYGBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.BlockStateProvidingFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.NetherVegetationFeature;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;

public class SpreadableBlock
extends SnowyDirtBlock
implements IGrowable {
    private final Block blockToSpreadToo;
    private final BlockStateProvidingFeatureConfig featureConfig;
    private final ForDimension forDimension;
    private final boolean isNotOverworld;

    public SpreadableBlock(AbstractBlock.Properties properties, Block blockToSpreadToo, ForDimension type, BlockStateProvidingFeatureConfig featureConfig) {
        super(properties);
        this.blockToSpreadToo = blockToSpreadToo;
        this.featureConfig = featureConfig;
        this.forDimension = type;
        this.isNotOverworld = this.forDimension != ForDimension.OVERWORLD;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.isNotOverworld) {
            if (!this.areConditionsGood(state, (IWorldReader)worldIn, pos)) {
                worldIn.func_175656_a(pos, this.blockToSpreadToo.func_176223_P());
            }
        } else if (!this.areConditionsGood(state, (IWorldReader)worldIn, pos)) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            worldIn.func_175656_a(pos, this.blockToSpreadToo.func_176223_P());
        } else if (worldIn.func_201696_r(pos.func_177984_a()) >= 9) {
            BlockState blockstate = this.func_176223_P();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!worldIn.func_180495_p(blockpos).func_203425_a(this.blockToSpreadToo) || !this.areConditionsGoodAndNotUnderWater(blockstate, (IWorldReader)worldIn, blockpos)) continue;
                worldIn.func_175656_a(blockpos, (BlockState)blockstate.func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos.func_177984_a()).func_203425_a(Blocks.field_150433_aE))));
            }
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_196958_f();
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos blockPos, BlockState state) {
        BlockPos blockpos = blockPos.func_177984_a();
        BlockState thisBlockState = rand.nextInt(2) == 0 ? Blocks.field_150349_c.func_176223_P() : BYGBlocks.SHORT_GRASS.func_176223_P();
        block0: for (int i = 0; i < world.func_217301_I(); ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    BlockState flowerState;
                    BlockState blockstate2 = world.func_180495_p(blockpos1);
                    if (this.isNotOverworld && blockstate2 == thisBlockState && rand.nextInt(10) == 0) {
                        ((IGrowable)thisBlockState.func_177230_c()).func_225535_a_(world, rand, blockpos1, blockstate2);
                    }
                    if (!blockstate2.func_196958_f()) continue block0;
                    if (this.forDimension == ForDimension.NETHER) {
                        NetherVegetationFeature.func_236325_a_((IWorld)world, (Random)rand, (BlockPos)blockpos1, (BlockStateProvidingFeatureConfig)this.featureConfig, (int)3, (int)1);
                        continue block0;
                    }
                    if (this.forDimension == ForDimension.END) {
                        EndVegetationFeature.placeBonemeal((IWorld)world, rand, blockpos1, this.featureConfig, 3, 1);
                        continue block0;
                    }
                    if (this.forDimension == ForDimension.OVERWORLD && this.featureConfig != null) {
                        OverworldVegetationFeature.placeBonemeal((IWorld)world, rand, blockpos1, this.featureConfig, 3, 1, (Block)this);
                        continue block0;
                    }
                    if (rand.nextInt(8) == 0) {
                        List flowerListForBiome = world.func_226691_t_(blockpos1).func_242440_e().func_242496_b();
                        if (flowerListForBiome.isEmpty()) continue;
                        ConfiguredFeature configuredfeature = (ConfiguredFeature)flowerListForBiome.get(0);
                        FlowersFeature flowersfeature = (FlowersFeature)configuredfeature.field_222737_a;
                        flowerState = flowersfeature.func_225562_b_(rand, blockpos1, configuredfeature.func_242767_c());
                    } else {
                        flowerState = thisBlockState;
                    }
                    if (!flowerState.func_196955_c((IWorldReader)world, blockpos1)) continue block0;
                    world.func_180501_a(blockpos1, flowerState, 3);
                    continue block0;
                }
                if (world.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != this || world.func_180495_p(blockpos1).func_200015_d((IBlockReader)world, blockpos1)) continue block0;
                ++j;
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        if (!this.isNotOverworld) {
            super.func_206840_a(builder);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.isNotOverworld) {
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return this.func_176223_P();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!this.isNotOverworld) {
            return super.func_196258_a(context);
        }
        return this.func_176223_P();
    }

    private boolean areConditionsGood(BlockState state, IWorldReader worldReader, BlockPos pos) {
        int i;
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = worldReader.func_180495_p(blockpos);
        if (!this.isNotOverworld) {
            if (blockstate.func_203425_a(Blocks.field_150433_aE) && (Integer)blockstate.func_177229_b((Property)SnowBlock.field_176315_a) == 1) {
                return true;
            }
            if (blockstate.func_204520_s().func_206882_g() == 8) {
                return false;
            }
        }
        return (i = LightEngine.func_215613_a((IBlockReader)worldReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)worldReader, blockpos))) < worldReader.func_201572_C();
    }

    private boolean areConditionsGoodAndNotUnderWater(BlockState state, IWorldReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        return this.areConditionsGood(state, worldReader, pos) && !worldReader.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static void addGrassBlocksForConsumption() {
    }

    public static enum ForDimension {
        OVERWORLD(DimensionType.field_236004_h_),
        NETHER(DimensionType.field_236005_i_),
        END(DimensionType.field_236006_j_);

        final DimensionType dimensionType;

        private ForDimension(DimensionType dimensionType) {
            this.dimensionType = dimensionType;
        }

        public DimensionType getDimType() {
            return this.dimensionType;
        }
    }
}

