/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.end.islands;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.FloatingIslandConfig;
import corgiaoc.byg.util.noise.fastnoise.lite.FastNoiseLite;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class FloatingIslands1
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands1(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        this.setSeed(world.func_72905_C());
        double radius = 15.0;
        if (world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n(), pos.func_177952_p()) > 4) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (double x = -radius; x <= radius; x += 1.0) {
            for (double y = 1.0; y <= radius; y += 1.0) {
                for (double z = -radius; z <= radius; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)(y - radius), (int)z);
                    double noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p()));
                    double scaledNoise = noise * (y * 3.0 / (x * x + z * z));
                    if (!(scaledNoise >= 0.5)) continue;
                    if (y == radius) {
                        world.func_180501_a((BlockPos)mutable, config.getTopBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                        continue;
                    }
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

