/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.end.islands;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.FloatingIslandConfig;
import corgiaoc.byg.util.noise.fastnoise.lite.FastNoiseLite;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class FloatingIslands3
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands3(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        double noise;
        double z;
        double y;
        double x;
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        double radius = rand.nextInt(config.getMaxPossibleRadius()) + config.getMinRadius() - 5;
        double thirdRadius = radius / 3.0;
        if (world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n(), pos.func_177952_p()) > 4) {
            return false;
        }
        for (x = -radius - 5.0; x <= radius + 5.0; x += 1.0) {
            for (y = -radius - 5.0; y <= radius + 5.0; y += 1.0) {
                for (z = -radius - 5.0; z <= radius + 5.0; z += 1.0) {
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(x, y, z));
                    double distanceSqt1 = x * x + y * y + z * z + noise * noise;
                    if (!(distanceSqt1 <= radius * radius)) continue;
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y, (int)z);
                    if (world.func_180495_p((BlockPos)mutable).func_185904_a() != Material.field_151579_a) continue;
                    if (y <= 1.0) {
                        world.func_180501_a((BlockPos)mutable, config.getTopBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                    }
                    if (!(y <= 0.0)) continue;
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -thirdRadius; x <= thirdRadius; x += 1.0) {
            for (y = -thirdRadius; y <= thirdRadius; y += 1.0) {
                for (z = -thirdRadius; z <= thirdRadius; z += 1.0) {
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(x, y, z));
                    double distanceSqt2 = x * x + y * y + z * z + noise * noise;
                    if (!(distanceSqt2 <= radius * (thirdRadius + 2.0)) || !(y <= 1.0) || !(y >= -1.0) || !(x <= 1.0) || !(x >= -2.0) || !(z <= 1.0) || !(z >= -2.0)) continue;
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x + 1, (int)y - 9, (int)z + 1);
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        return false;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

