/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.end.islands;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.FloatingIslandConfig;
import corgiaoc.byg.util.noise.fastnoise.lite.FastNoiseLite;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class FloatingIslands5
extends Feature<FloatingIslandConfig> {
    FastNoiseLite perlin = null;

    public FloatingIslands5(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        double scaledNoise;
        double noise;
        double z;
        double y;
        double x;
        this.setSeed(world.func_72905_C());
        if (world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n(), pos.func_177952_p()) > 4) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        double radius = 25.0;
        double radiusFifth = radius / 5.0;
        for (x = -radiusFifth - 5.0; x <= radiusFifth + 5.0; x += 1.0) {
            for (y = 1.0; y <= radiusFifth + 11.0; y += 1.0) {
                for (z = -radiusFifth - 5.0; z <= radiusFifth + 5.0; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y + 6, (int)z);
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p()));
                    scaledNoise = noise * (Math.pow(y / 2.0, 2.0) / (Math.pow(x, 2.0) + Math.pow(z, 2.0)));
                    if (!(scaledNoise <= 0.5)) continue;
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radius - 2.0; x <= radius + 2.0; x += 1.0) {
            for (y = 1.0; y <= radius + 11.0; y += 1.0) {
                for (z = -radius - 2.0; z <= radius + 2.0; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y - 22, (int)z);
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p()));
                    scaledNoise = noise * (Math.pow(y / 4.0, 2.0) / (Math.pow(x, 2.0) + Math.pow(z, 2.0)));
                    if (!(scaledNoise >= 0.5)) continue;
                    if (y == 36.0) {
                        world.func_180501_a((BlockPos)mutable, config.getTopBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                        continue;
                    }
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radiusFifth - 2.0; x <= radiusFifth + 2.0; x += 1.0) {
            for (y = 1.0; y <= radiusFifth + 11.0; y += 1.0) {
                for (z = -radiusFifth - 2.0; z <= radiusFifth + 2.0; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y + 5, (int)z);
                    noise = FastNoiseLite.getSpongePerlinValue(this.perlin.GetNoise(mutable.func_177958_n(), mutable.func_177956_o(), mutable.func_177952_p()));
                    scaledNoise = noise * (Math.pow(y / 2.0, 2.0) / (Math.pow(x, 2.0) + Math.pow(z, 2.0)));
                    if (!(scaledNoise >= 0.5)) continue;
                    world.func_180501_a((BlockPos)mutable, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

