/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.end.islands.shattered;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.FloatingIslandConfig;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class ShatteredFloatingIslands1
extends Feature<FloatingIslandConfig> {
    FastNoise perlin = null;

    public ShatteredFloatingIslands1(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        this.setSeed(world.func_72905_C());
        double radius = rand.nextInt(config.getMaxPossibleRadius()) + config.getMinRadius();
        if (world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n(), pos.func_177952_p()) > 4) {
            return false;
        }
        int modifiedRadiusOnY = (int)(radius + 11.0);
        for (double x = -radius; x <= radius; x += 1.0) {
            for (double y = -radius; y <= (double)modifiedRadiusOnY; y += 1.0) {
                for (double z = -radius; z <= radius; z += 1.0) {
                    double noise = this.perlin.GetNoise((float)x, (float)y, (float)z) * 12.0f;
                    double scaledNoise = noise / 11.0 * (y * 3.0 / (x * x + z * z));
                    if (!(scaledNoise >= 0.5) || !(y >= 1.0)) continue;
                    world.func_180501_a(pos.func_177963_a(x, y - (double)modifiedRadiusOnY, z), config.getBlockProvider().func_225574_a_(rand, pos), 2);
                    if (y != (double)modifiedRadiusOnY) continue;
                    world.func_180501_a(pos.func_177963_a(x, y - (double)modifiedRadiusOnY, z), config.getTopBlockProvider().func_225574_a_(rand, pos), 2);
                }
            }
        }
        return false;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = new FastNoise((int)seed);
            this.perlin.SetNoiseType(FastNoise.NoiseType.Perlin);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

