/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.end.islands.shattered;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.FloatingIslandConfig;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class ShatteredFloatingIslands4
extends Feature<FloatingIslandConfig> {
    FastNoise perlin = null;

    public ShatteredFloatingIslands4(Codec<FloatingIslandConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, FloatingIslandConfig config) {
        double z;
        double y;
        double x;
        this.setSeed(world.func_72905_C());
        if (world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n(), pos.func_177952_p()) > 4) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        double radius = 13.0;
        double size = radius / 3.0;
        double radiusHalved = radius / 2.0;
        for (x = -radius; x <= radius; x += 1.0) {
            for (y = -radius; y <= 1.0; y += 1.0) {
                for (z = -radius; z <= radius; z += 1.0) {
                    double squareNoise1 = this.perlin.GetNoise((float)x, (float)y, (float)z) * 12.0f - 6.0f;
                    double distanceSqt1 = x * x + y * y + z * z + squareNoise1 * squareNoise1;
                    if (!(distanceSqt1 <= radius * radius) || !(y <= 1.0)) continue;
                    world.func_180501_a(mutable.func_177963_a(x, y, z), config.getTopBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                    if (!(y <= 0.0)) continue;
                    world.func_180501_a(mutable.func_177963_a(x, y, z), config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                    if (!(y <= -2.0)) continue;
                    world.func_180501_a(mutable.func_177963_a(x, y, z), config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        for (x = -radiusHalved; x <= radiusHalved; x += 1.0) {
            for (y = -size; y <= size; y += 1.0) {
                for (z = -radiusHalved; z <= radiusHalved; z += 1.0) {
                    double distanceSqt1 = x * x + y * y + z * z;
                    if (!(distanceSqt1 <= radiusHalved * radiusHalved) || !(y <= 2.0)) continue;
                    world.func_180501_a(mutable.func_177963_a(x, y, z), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.perlin == null) {
            this.perlin = new FastNoise((int)seed);
            this.perlin.SetNoiseType(FastNoise.NoiseType.Perlin);
            this.perlin.SetFrequency(0.2f);
        }
    }
}

