/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.end.purpurpeaks;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.SimpleBlockProviderConfig;
import corgiaoc.byg.util.noise.fastnoise.lite.FastNoiseLite;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class PurpurPeak
extends Feature<SimpleBlockProviderConfig> {
    FastNoiseLite fnlPerlin = null;

    public PurpurPeak(Codec<SimpleBlockProviderConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, SimpleBlockProviderConfig config) {
        this.setSeed(world.func_72905_C());
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151579_a || world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151587_i || world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, pos.func_177958_n(), pos.func_177952_p()) < 4) {
            return false;
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        double baseRadius = 15.0;
        int peakHeight = 125;
        int peakStartHeight = peakHeight - 5;
        double threshold = 0.5;
        for (double y = (double)(-peakHeight); y <= (double)peakHeight; y += 1.0) {
            for (double x = (double)(-peakHeight); x <= (double)peakHeight; x += 1.0) {
                for (double z = (double)(-peakHeight); z <= (double)peakHeight; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y + peakStartHeight, (int)z);
                    float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.func_177958_n(), mutable.func_177952_p()));
                    double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                    if (y == (double)(-peakHeight) && scaledNoise >= threshold && world.func_180495_p(mutable.func_177972_a(Direction.DOWN)).func_185904_a() == Material.field_151579_a) {
                        return false;
                    }
                    if (!(scaledNoise >= threshold) || !world.func_175623_d((BlockPos)mutable)) continue;
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

