/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.nether.warpeddesert;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.WhitelistedSimpleBlockProviderConfig;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class WarpedCoralFeature
extends Feature<WhitelistedSimpleBlockProviderConfig> {
    public WarpedCoralFeature(Codec<WhitelistedSimpleBlockProviderConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, WhitelistedSimpleBlockProviderConfig config) {
        int randCoralHeight = rand.nextInt(7) + 8;
        if (!this.checkArea((IWorld)worldIn, pos, rand, config)) {
            return false;
        }
        if (config.getWhitelist().contains(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            for (int i = 0; i <= randCoralHeight; ++i) {
                BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
                this.placeCoral(worldIn, (BlockPos)mutable, rand, config);
                this.placeCoral(worldIn, (BlockPos)mutable.func_189534_c(Direction.UP, i), rand, config);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.placeCoral(worldIn, mutable.func_177967_a(direction, i / 2), rand, config);
                }
            }
        }
        return true;
    }

    private void placeCoral(ISeedReader world, BlockPos pos, Random rand, WhitelistedSimpleBlockProviderConfig config) {
        if (world.func_175623_d(pos)) {
            world.func_180501_a(pos, config.getBlockProvider().func_225574_a_(rand, pos), 2);
        }
    }

    private boolean checkArea(IWorld world, BlockPos pos, Random rand, WhitelistedSimpleBlockProviderConfig config) {
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int checkX = -2; checkX <= 2; ++checkX) {
            for (int checkZ = -2; checkZ <= 2; ++checkZ) {
                mutable.func_181079_c(posX + checkX, posY, posZ + checkZ);
                if (!world.func_175623_d((BlockPos)mutable)) {
                    return false;
                }
                if (world.func_180495_p((BlockPos)mutable) != config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable)) continue;
                return false;
            }
        }
        return true;
    }
}

